@props([
    'tabs' => [],
    'active' => null,
    'id' => 'tabs-' . uniqid(),
])

@php $active = $active ?? ($tabs[0] ?? ''); @endphp

<div x-data="{ activeTab: '{{ $active }}' }" {{ $attributes }}>
    <div class="border-b border-gray-200 mb-6">
        <nav class="-mb-px flex space-x-8 space-x-reverse overflow-x-auto" aria-label="Tabs">
            @foreach($tabs as $key => $label)
                @php $tabKey = is_string($key) ? $key : $label; @endphp
                <button @click="activeTab = '{{ $tabKey }}'"
                    :class="activeTab === '{{ $tabKey }}'
                        ? 'border-blue-500 text-blue-600'
                        : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                    class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors">
                    {{ $label }}
                </button>
            @endforeach
        </nav>
    </div>
    {{ $slot }}
</div>
