<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">حجوزاتي</h1><p class="text-sm text-gray-500">سجل جميع حجوزات الخدمات</p></div>
                <a href="{{ route('customer.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                @if($bookings->isEmpty())
                    <div class="p-8 text-center">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" /></svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">لا توجد حجوزات</h3>
                        <p class="mt-1 text-sm text-gray-500">ابدأ بحجز موعد صيانة أو تجربة قيادة.</p>
                        <div class="mt-6"><a href="{{ route('booking.index') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm">حجز جديد</a></div>
                    </div>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50"><tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الخدمة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المركبة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">التاريخ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الوقت</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                            </tr></thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($bookings as $booking)
                                    <tr>
                                        <td class="px-6 py-4 text-sm font-medium text-gray-900">{{ $booking->serviceType->name ?? 'خدمة عامة' }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $booking->vehicle->make ?? '' }} {{ $booking->vehicle->model ?? '' }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $booking->date->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $booking->time ?? '-' }}</td>
                                        <td class="px-6 py-4"><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $booking->status === 'CONFIRMED' ? 'bg-green-100 text-green-800' : ($booking->status === 'CANCELLED' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $booking->status }}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4">{{ $bookings->links() }}</div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
