<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">تفاصيل الحجز</h1><p class="text-sm text-gray-500">#{{ $booking->id }}</p></div>
                <a href="{{ route('customer.bookings') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للحجوزات</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="p-6 border-b">
                    <div class="grid grid-cols-2 gap-6">
                        <div><p class="text-sm text-gray-500">نوع الخدمة</p><p class="font-medium">{{ $booking->serviceType->name ?? 'غير محدد' }}</p></div>
                        <div><p class="text-sm text-gray-500">الحالة</p><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $booking->status === 'COMPLETED' ? 'bg-green-100 text-green-800' : ($booking->status === 'CANCELLED' ? 'bg-red-100 text-red-800' : ($booking->status === 'CONFIRMED' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800')) }}">{{ $booking->status }}</span></div>
                        <div><p class="text-sm text-gray-500">التاريخ</p><p class="font-medium">{{ $booking->date instanceof \Carbon\Carbon ? $booking->date->format('Y-m-d') : $booking->date }}</p></div>
                        <div><p class="text-sm text-gray-500">الوقت</p><p class="font-medium">{{ $booking->time ?? $booking->time_slot ?? '-' }}</p></div>
                        @if($booking->vehicle)
                        <div><p class="text-sm text-gray-500">المركبة</p><p class="font-medium">{{ $booking->vehicle->make ?? '' }} {{ $booking->vehicle->model ?? '' }} {{ $booking->vehicle->year ?? '' }}</p></div>
                        @endif
                        @if($booking->total_price)
                        <div><p class="text-sm text-gray-500">السعر</p><p class="font-medium">{{ number_format($booking->total_price, 2) }} EGP</p></div>
                        @endif
                    </div>
                </div>
                @if($booking->notes)
                <div class="p-6">
                    <p class="text-sm text-gray-500 mb-2">ملاحظات</p>
                    <p class="text-gray-700">{{ $booking->notes }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
