<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">التأمين</h1><p class="text-sm text-gray-500">وثائق التأمين والمطالبات</p></div>
                <a href="{{ route('customer.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">وثائق التأمين</h3></div>
                @if($policies->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد وثائق تأمين.</div>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50"><tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">رقم الوثيقة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الشركة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المركبة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">القسط</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الصلاحية</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                            </tr></thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($policies as $policy)
                                    <tr>
                                        <td class="px-6 py-4 text-sm font-mono text-indigo-600">{{ $policy->policy_number }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $policy->company->name ?? 'N/A' }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $policy->vehicle->make ?? '' }} {{ $policy->vehicle->model ?? '' }}</td>
                                        <td class="px-6 py-4 text-sm font-bold">{{ number_format($policy->premium ?? 0, 2) }} EGP</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $policy->start_date->format('Y-m-d') }} — {{ $policy->end_date->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4"><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $policy->status === 'ACTIVE' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">{{ $policy->status }}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4">{{ $policies->links() }}</div>
                @endif
            </div>

            @if($claims->count())
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">مطالبات التأمين الأخيرة</h3></div>
                <div class="divide-y divide-gray-200">
                    @foreach($claims as $claim)
                        <div class="p-4">
                            <div class="flex justify-between items-start">
                                <div><p class="text-sm font-medium text-gray-900">{{ $claim->claim_number }}</p><p class="text-sm text-gray-500">{{ Str::limit($claim->description, 60) }}</p></div>
                                <span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $claim->status === 'APPROVED' ? 'bg-green-100 text-green-800' : ($claim->status === 'REJECTED' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $claim->status }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</x-public-layout>
