<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">فواتيري</h1><p class="text-sm text-gray-500">عرض جميع الفواتير الخاصة بك</p></div>
                <a href="{{ route('customer.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-blue-500"><p class="text-sm text-gray-500">إجمالي الفواتير</p><p class="text-2xl font-bold">{{ $stats['total'] }}</p></div>
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-green-500"><p class="text-sm text-gray-500">مدفوعة</p><p class="text-2xl font-bold text-green-600">{{ $stats['paid'] }}</p></div>
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-red-500"><p class="text-sm text-gray-500">غير مدفوعة</p><p class="text-2xl font-bold text-red-600">{{ $stats['unpaid'] }}</p></div>
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-purple-500"><p class="text-sm text-gray-500">المبلغ الإجمالي</p><p class="text-2xl font-bold">{{ number_format($stats['total_amount'], 2) }} EGP</p></div>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                @if($invoices->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد فواتير حتى الآن.</div>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50"><tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">رقم الفاتورة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">التاريخ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المبلغ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">إجراءات</th>
                            </tr></thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($invoices as $invoice)
                                    <tr>
                                        <td class="px-6 py-4 text-sm font-mono text-indigo-600">{{ $invoice->invoice_number }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $invoice->issue_date->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4 text-sm font-bold">{{ number_format($invoice->total_amount, 2) }} {{ $invoice->currency }}</td>
                                        <td class="px-6 py-4"><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $invoice->status === 'PAID' ? 'bg-green-100 text-green-800' : ($invoice->status === 'OVERDUE' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $invoice->status }}</span></td>
                                        <td class="px-6 py-4 text-sm"><a href="{{ route('customer.invoices.show', $invoice->id) }}" class="text-blue-600 hover:text-blue-800">عرض</a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4">{{ $invoices->links() }}</div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
