<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <h1 class="text-2xl font-bold text-gray-900">فاتورة #{{ $invoice->invoice_number }}</h1>
                <a href="{{ route('customer.invoices') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للفواتير</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="p-6 border-b border-gray-200">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div><p class="text-sm text-gray-500">التاريخ</p><p class="font-medium">{{ $invoice->issue_date->format('Y-m-d') }}</p></div>
                        <div><p class="text-sm text-gray-500">تاريخ الاستحقاق</p><p class="font-medium">{{ $invoice->due_date?->format('Y-m-d') ?? '-' }}</p></div>
                        <div><p class="text-sm text-gray-500">الحالة</p><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $invoice->status === 'PAID' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">{{ $invoice->status }}</span></div>
                        <div><p class="text-sm text-gray-500">الإجمالي</p><p class="text-xl font-bold text-gray-900">{{ number_format($invoice->total_amount, 2) }} {{ $invoice->currency }}</p></div>
                    </div>
                </div>

                @if($invoice->items && $invoice->items->count())
                <div class="p-6">
                    <h3 class="font-medium text-gray-900 mb-4">بنود الفاتورة</h3>
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50"><tr>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">البند</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">الكمية</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">السعر</th>
                            <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">الإجمالي</th>
                        </tr></thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach($invoice->items as $item)
                                <tr>
                                    <td class="px-4 py-3 text-sm">{{ $item->description }}</td>
                                    <td class="px-4 py-3 text-sm">{{ $item->quantity }}</td>
                                    <td class="px-4 py-3 text-sm">{{ number_format($item->unit_price, 2) }}</td>
                                    <td class="px-4 py-3 text-sm font-medium">{{ number_format($item->total, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @endif

                @if($invoice->payments && $invoice->payments->count())
                <div class="p-6 border-t border-gray-200">
                    <h3 class="font-medium text-gray-900 mb-4">المدفوعات</h3>
                    @foreach($invoice->payments as $payment)
                        <div class="flex justify-between items-center p-3 bg-green-50 rounded mb-2">
                            <div class="text-sm"><span class="font-medium">{{ number_format($payment->amount, 2) }}</span> — {{ $payment->payment_method ?? 'غير محدد' }}</div>
                            <div class="text-xs text-gray-500">{{ $payment->created_at->format('Y-m-d') }}</div>
                        </div>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
