<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">طلباتي</h1><p class="text-sm text-gray-500">عرض جميع الطلبات</p></div>
                <a href="{{ route('customer.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                @if($orders->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد طلبات حتى الآن.</div>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50"><tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">رقم الطلب</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">التاريخ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المبلغ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">إجراءات</th>
                            </tr></thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($orders as $order)
                                    <tr>
                                        <td class="px-6 py-4 text-sm font-mono text-indigo-600">{{ $order->order_number }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $order->created_at->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4 text-sm font-bold">{{ number_format($order->total ?? 0, 2) }} EGP</td>
                                        <td class="px-6 py-4"><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $order->status === 'DELIVERED' ? 'bg-green-100 text-green-800' : ($order->status === 'CANCELLED' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $order->status }}</span></td>
                                        <td class="px-6 py-4 text-sm"><a href="{{ route('customer.orders.show', $order->id) }}" class="text-blue-600 hover:text-blue-800">عرض التفاصيل</a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4">{{ $orders->links() }}</div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
