<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <h1 class="text-2xl font-bold text-gray-900">طلب #{{ $order->order_number }}</h1>
                <a href="{{ route('customer.orders') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للطلبات</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="p-6 border-b">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div><p class="text-sm text-gray-500">التاريخ</p><p class="font-medium">{{ $order->created_at->format('Y-m-d') }}</p></div>
                        <div><p class="text-sm text-gray-500">الحالة</p><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $order->status === 'DELIVERED' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">{{ $order->status }}</span></div>
                        <div><p class="text-sm text-gray-500">طريقة الدفع</p><p class="font-medium">{{ $order->payment_method ?? 'غير محدد' }}</p></div>
                        <div><p class="text-sm text-gray-500">الإجمالي</p><p class="text-xl font-bold">{{ number_format($order->total ?? 0, 2) }} EGP</p></div>
                    </div>
                </div>
                @if($order->items && $order->items->count())
                <div class="p-6">
                    <h3 class="font-medium text-gray-900 mb-4">عناصر الطلب</h3>
                    <div class="space-y-3">
                        @foreach($order->items as $item)
                            <div class="flex justify-between items-center p-3 bg-gray-50 rounded">
                                <div><p class="text-sm font-medium">{{ $item->name ?? $item->product->name ?? 'منتج' }}</p><p class="text-xs text-gray-500">الكمية: {{ $item->quantity }}</p></div>
                                <p class="font-medium">{{ number_format($item->total ?? ($item->quantity * $item->price), 2) }} EGP</p>
                            </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
