<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <h1 class="text-2xl font-bold text-gray-900">الملف الشخصي</h1>
                <a href="{{ route('customer.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            @if(session('success'))<div class="mb-4 p-3 bg-green-50 text-green-700 rounded-lg text-sm">{{ session('success') }}</div>@endif
            @if($errors->any())<div class="mb-4 p-3 bg-red-50 text-red-700 rounded-lg text-sm">@foreach($errors->all() as $e)<p>{{ $e }}</p>@endforeach</div>@endif

            <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">المعلومات الأساسية</h3></div>
                <form method="POST" action="{{ route('customer.profile.update') }}" class="p-6 space-y-4">
                    @csrf @method('PATCH')
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">الاسم</label><input type="text" name="name" value="{{ old('name', $user->name) }}" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">البريد الإلكتروني</label><input type="email" name="email" value="{{ old('email', $user->email) }}" required class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">الهاتف</label><input type="text" name="phone" value="{{ old('phone', $user->phone) }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">العنوان</label><textarea name="address" rows="2" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">{{ old('address', $user->address) }}</textarea></div>
                    <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">حفظ التغييرات</button>
                </form>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">تغيير كلمة المرور</h3></div>
                <form method="POST" action="{{ route('customer.profile.password') }}" class="p-6 space-y-4">
                    @csrf @method('PATCH')
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">كلمة المرور الحالية</label><input type="password" name="current_password" required class="block w-full rounded-md border-gray-300 shadow-sm"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">كلمة المرور الجديدة</label><input type="password" name="password" required class="block w-full rounded-md border-gray-300 shadow-sm"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">تأكيد كلمة المرور</label><input type="password" name="password_confirmation" required class="block w-full rounded-md border-gray-300 shadow-sm"></div>
                    <button type="submit" class="px-6 py-2 bg-orange-600 text-white rounded-lg hover:bg-orange-700">تغيير كلمة المرور</button>
                </form>
            </div>
        </div>
    </div>
</x-public-layout>
