<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">تذاكر الدعم</h1><p class="text-sm text-gray-500">تواصل معنا لأي استفسار أو مشكلة</p></div>
                <div class="flex gap-3">
                    <button onclick="document.getElementById('newTicketModal').classList.remove('hidden')" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 text-sm">+ تذكرة جديدة</button>
                    <a href="{{ route('customer.dashboard') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 text-sm">← العودة</a>
                </div>
            </div>

            @if(session('success'))<div class="mb-4 p-3 bg-green-50 text-green-700 rounded-lg text-sm">{{ session('success') }}</div>@endif

            <div class="bg-white shadow rounded-lg overflow-hidden">
                @if($tickets->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد تذاكر دعم.</div>
                @else
                    <div class="divide-y divide-gray-200">
                        @foreach($tickets as $ticket)
                            <div class="p-6 hover:bg-gray-50">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <a href="{{ route('customer.support.show', $ticket->id) }}" class="text-sm font-medium text-indigo-600 hover:text-indigo-800">{{ $ticket->ticket_number }}</a>
                                        <h3 class="font-medium text-gray-900 mt-1">{{ $ticket->subject }}</h3>
                                        <p class="text-sm text-gray-500 mt-1">{{ Str::limit($ticket->description, 100) }}</p>
                                    </div>
                                    <div class="text-left">
                                        <span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $ticket->status === 'OPEN' ? 'bg-blue-100 text-blue-800' : ($ticket->status === 'CLOSED' ? 'bg-gray-100 text-gray-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $ticket->status }}</span>
                                        <p class="text-xs text-gray-400 mt-2">{{ $ticket->created_at->diffForHumans() }}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="p-4">{{ $tickets->links() }}</div>
                @endif
            </div>
        </div>
    </div>

    <div id="newTicketModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-20 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white" dir="rtl">
            <h3 class="text-lg font-medium mb-4">تذكرة دعم جديدة</h3>
            <form method="POST" action="{{ route('customer.support.store') }}" class="space-y-4">@csrf
                <div><label class="block text-sm font-medium text-gray-700 mb-1">الموضوع</label><input type="text" name="subject" required class="block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div><label class="block text-sm font-medium text-gray-700 mb-1">الوصف</label><textarea name="description" rows="4" required class="block w-full rounded-md border-gray-300 shadow-sm"></textarea></div>
                <div><label class="block text-sm font-medium text-gray-700 mb-1">الأولوية</label><select name="priority" class="block w-full rounded-md border-gray-300 shadow-sm"><option value="LOW">منخفضة</option><option value="MEDIUM" selected>متوسطة</option><option value="HIGH">عالية</option><option value="URGENT">عاجلة</option></select></div>
                <div class="flex justify-end space-x-2 space-x-reverse"><button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">إلغاء</button><button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">إرسال</button></div>
            </form>
        </div>
    </div>
</x-public-layout>
