<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">{{ $ticket->subject }}</h1><p class="text-sm text-gray-500">#{{ $ticket->ticket_number }}</p></div>
                <a href="{{ route('customer.support') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للتذاكر</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
                <div class="p-6 border-b">
                    <div class="grid grid-cols-3 gap-4">
                        <div><p class="text-sm text-gray-500">الحالة</p><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $ticket->status === 'OPEN' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800' }}">{{ $ticket->status }}</span></div>
                        <div><p class="text-sm text-gray-500">الأولوية</p><span class="font-medium">{{ $ticket->priority ?? 'MEDIUM' }}</span></div>
                        <div><p class="text-sm text-gray-500">التاريخ</p><span class="font-medium">{{ $ticket->created_at->format('Y-m-d H:i') }}</span></div>
                    </div>
                </div>
                <div class="p-6"><p class="text-gray-700 whitespace-pre-line">{{ $ticket->description }}</p></div>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">التعليقات</h3></div>
                @if($ticket->comments && $ticket->comments->count())
                    <div class="divide-y divide-gray-200">
                        @foreach($ticket->comments as $comment)
                            <div class="p-4 {{ $comment->author_id !== auth()->id() ? 'bg-blue-50' : '' }}">
                                <div class="flex justify-between mb-1">
                                    <span class="text-sm font-medium text-gray-900">{{ $comment->author->name ?? 'مجهول' }}</span>
                                    <span class="text-xs text-gray-500">{{ $comment->created_at->diffForHumans() }}</span>
                                </div>
                                <p class="text-sm text-gray-700">{{ $comment->content }}</p>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="p-6 text-center text-gray-500 text-sm">لا توجد تعليقات بعد.</div>
                @endif
            </div>

            @if($ticket->status !== 'CLOSED')
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <form method="POST" action="{{ route('customer.support.comment', $ticket->id) }}" class="p-6">@csrf
                    <label class="block text-sm font-medium text-gray-700 mb-2">إضافة تعليق</label>
                    <textarea name="content" rows="3" required class="block w-full rounded-md border-gray-300 shadow-sm mb-3"></textarea>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700 text-sm">إرسال التعليق</button>
                </form>
            </div>
            @endif
        </div>
    </div>
</x-public-layout>
