<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">الضمانات</h1><p class="text-sm text-gray-500">عرض الضمانات والمطالبات</p></div>
                <a href="{{ route('customer.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            @if(session('success'))<div class="mb-4 p-3 bg-green-50 text-green-700 rounded-lg text-sm">{{ session('success') }}</div>@endif

            <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">ضماناتي</h3></div>
                @if($warranties->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد ضمانات مسجلة.</div>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50"><tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المركبة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">النوع</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">بداية</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">نهاية</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">إجراءات</th>
                            </tr></thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($warranties as $w)
                                    <tr>
                                        <td class="px-6 py-4 text-sm text-gray-900">{{ $w->vehicle->make ?? '' }} {{ $w->vehicle->model ?? '' }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $w->type }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $w->start_date?->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $w->end_date?->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4"><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $w->status === 'ACTIVE' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">{{ $w->status }}</span></td>
                                        <td class="px-6 py-4 text-sm">
                                            @if($w->status === 'ACTIVE')
                                                <button onclick="document.getElementById('claimModal{{ $w->id }}').classList.remove('hidden')" class="text-blue-600 hover:text-blue-800">مطالبة</button>
                                            @endif
                                        </td>
                                    </tr>
                                    @if($w->status === 'ACTIVE')
                                    <div id="claimModal{{ $w->id }}" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
                                        <div class="relative top-20 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white" dir="rtl">
                                            <h3 class="text-lg font-medium mb-4">تقديم مطالبة ضمان</h3>
                                            <form method="POST" action="{{ route('customer.warranties.claim') }}" class="space-y-4">@csrf
                                                <input type="hidden" name="warranty_id" value="{{ $w->id }}">
                                                <div><label class="block text-sm font-medium text-gray-700 mb-1">نوع المشكلة</label><input type="text" name="issue_type" required class="block w-full rounded-md border-gray-300 shadow-sm"></div>
                                                <div><label class="block text-sm font-medium text-gray-700 mb-1">وصف المشكلة</label><textarea name="description" rows="3" required class="block w-full rounded-md border-gray-300 shadow-sm"></textarea></div>
                                                <div class="flex justify-end space-x-2 space-x-reverse"><button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">إلغاء</button><button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">إرسال</button></div>
                                            </form>
                                        </div>
                                    </div>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4">{{ $warranties->links() }}</div>
                @endif
            </div>

            @if($claims->count())
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">المطالبات الأخيرة</h3></div>
                <div class="divide-y divide-gray-200">
                    @foreach($claims as $claim)
                        <div class="p-4">
                            <div class="flex justify-between items-start">
                                <div><p class="text-sm font-medium text-gray-900">{{ $claim->claim_number }}</p><p class="text-sm text-gray-500">{{ $claim->issue_type }} — {{ Str::limit($claim->description, 60) }}</p></div>
                                <span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $claim->status === 'APPROVED' ? 'bg-green-100 text-green-800' : ($claim->status === 'REJECTED' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $claim->status }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</x-public-layout>
