<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">سجل الحضور</h1><p class="text-sm text-gray-500">{{ now()->format('F Y') }}</p></div>
                <a href="{{ route('employee.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            @if(session('success'))<div class="mb-4 p-3 bg-green-50 text-green-700 rounded-lg text-sm">{{ session('success') }}</div>@endif
            @if(session('error'))<div class="mb-4 p-3 bg-red-50 text-red-700 rounded-lg text-sm">{{ session('error') }}</div>@endif

            <!-- Clock In/Out -->
            <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
                <div class="flex items-center justify-between flex-wrap gap-4">
                    <div>
                        <h3 class="font-medium text-gray-900">اليوم: {{ now()->format('l, Y-m-d') }}</h3>
                        @if($todayRecord)
                            <p class="text-sm text-gray-500 mt-1">
                                تسجيل الحضور: {{ $todayRecord->check_in ? \Carbon\Carbon::parse($todayRecord->check_in)->format('H:i') : '-' }}
                                @if($todayRecord->check_out) | الانصراف: {{ \Carbon\Carbon::parse($todayRecord->check_out)->format('H:i') }} @endif
                            </p>
                        @else
                            <p class="text-sm text-gray-500 mt-1">لم يتم تسجيل الحضور بعد</p>
                        @endif
                    </div>
                    <div class="flex gap-2">
                        @if(!$todayRecord)
                            <form method="POST" action="{{ route('employee.attendance.clockin') }}">@csrf
                                <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm">🕐 تسجيل حضور</button>
                            </form>
                        @elseif(!$todayRecord->check_out)
                            <form method="POST" action="{{ route('employee.attendance.clockout') }}">@csrf
                                <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 text-sm">🕐 تسجيل انصراف</button>
                            </form>
                        @else
                            <span class="px-4 py-2 bg-gray-100 text-gray-500 rounded-lg text-sm">✅ مكتمل</span>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Stats -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-green-500"><p class="text-sm text-gray-500">حاضر</p><p class="text-2xl font-bold text-green-600">{{ $stats['present'] }}</p></div>
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-red-500"><p class="text-sm text-gray-500">غائب</p><p class="text-2xl font-bold text-red-600">{{ $stats['absent'] }}</p></div>
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-yellow-500"><p class="text-sm text-gray-500">متأخر</p><p class="text-2xl font-bold text-yellow-600">{{ $stats['late'] }}</p></div>
                <div class="bg-white p-4 rounded-lg shadow-sm border-b-4 border-blue-500"><p class="text-sm text-gray-500">أيام العمل</p><p class="text-2xl font-bold">{{ $stats['working_days'] }}</p></div>
            </div>

            <!-- Records Table -->
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">السجل</h3></div>
                @if($records->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد سجلات حضور.</div>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50"><tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">التاريخ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحضور</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الانصراف</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                            </tr></thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($records as $record)
                                    <tr>
                                        <td class="px-6 py-4 text-sm">{{ $record->date->format('Y-m-d (l)') }}</td>
                                        <td class="px-6 py-4 text-sm">{{ $record->check_in ? \Carbon\Carbon::parse($record->check_in)->format('H:i') : '-' }}</td>
                                        <td class="px-6 py-4 text-sm">{{ $record->check_out ? \Carbon\Carbon::parse($record->check_out)->format('H:i') : '-' }}</td>
                                        <td class="px-6 py-4"><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $record->status === 'PRESENT' ? 'bg-green-100 text-green-800' : ($record->status === 'LATE' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') }}">{{ $record->status }}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4">{{ $records->links() }}</div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
