<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('لوحة تحكم الموظف') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            
            {{-- Profile Status --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="text-lg font-medium">مرحباً، {{ $user->name }}</h3>
                            @if($profile)
                                <p class="text-gray-500">{{ $profile->position }} - {{ $profile->department }}</p>
                            @else
                                <p class="text-yellow-500">يرجى استكمال ملفك الوظيفي</p>
                            @endif
                        </div>
                        <div class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm">
                            {{ $user->status ?? 'نشط' }}
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                {{-- Quick Stats --}}
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                    <div class="flex items-center gap-4">
                        <div class="p-3 bg-green-100 rounded-full text-green-600">
                            <x-icon name="DollarSign" class="w-6 h-6" />
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">الراتب الأساسي</p>
                            <p class="text-xl font-bold">{{ $profile ? number_format($profile->salary, 2) : '-' }} ج.م</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                    <div class="flex items-center gap-4">
                        <div class="p-3 bg-orange-100 rounded-full text-orange-600">
                            <x-icon name="Calendar" class="w-6 h-6" />
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">الإجازات المعلقة</p>
                            <p class="text-xl font-bold">{{ $pendingLeaves->count() }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                    <div class="flex items-center gap-4">
                        <div class="p-3 bg-purple-100 rounded-full text-purple-600">
                            <x-icon name="Clock" class="w-6 h-6" />
                        </div>
                        <div>
                            <p class="text-sm text-gray-500">تاريخ التعيين</p>
                            <p class="text-xl font-bold">{{ $profile ? \Carbon\Carbon::parse($profile->hire_date)->format('Y-m-d') : '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Actions Grid --}}
             <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                {{-- Leaves --}}
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-bold">الإجازات</h3>
                        <a href="{{ route('employee.leaves.index') }}" class="text-blue-600 hover:underline text-sm">عرض الكل</a>
                    </div>
                    
                    @if($pendingLeaves->count() > 0)
                        <div class="space-y-3">
                            @foreach($pendingLeaves->take(3) as $leave)
                                <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                                    <div>
                                        <div class="font-medium">{{ $leave->leave_type }}</div>
                                        <div class="text-xs text-gray-500">{{ $leave->start_date }} - {{ $leave->end_date }}</div>
                                    </div>
                                    <span class="px-2 py-1 text-xs rounded bg-yellow-100 text-yellow-800">قيد الانتظار</span>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-gray-500 text-sm text-center py-4">لا توجد طلبات إجازة معلقة</p>
                    @endif
                    
                    <div class="mt-4">
                         <a href="{{ route('employee.leaves.index') }}" class="block w-full py-2 bg-gray-100 text-gray-700 text-center rounded hover:bg-gray-200 transition">
                            طلب إجازة جديدة
                        </a>
                    </div>
                </div>

                {{-- Payroll --}}
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-bold">الرواتب</h3>
                        <a href="{{ route('employee.payroll.index') }}" class="text-blue-600 hover:underline text-sm">عرض الكل</a>
                    </div>

                    @if($latestPayroll)
                        <div class="bg-blue-50 p-4 rounded-lg border border-blue-100">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-blue-800 font-medium">راتب شهر {{ $latestPayroll->period }}</span>
                                <span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800">{{ $latestPayroll->status }}</span>
                            </div>
                            <div class="text-3xl font-bold text-gray-900 mb-1">
                                {{ number_format($latestPayroll->net_salary, 2) }} <span class="text-sm font-normal text-gray-500">ج.م</span>
                            </div>
                            <div class="text-xs text-gray-500">
                                تاريخ الصرف: {{ $latestPayroll->paid_date ?? 'لم يتم الصرف بعد' }}
                            </div>
                        </div>
                    @else
                        <p class="text-gray-500 text-sm text-center py-4">لا توجد سجلات رواتب</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
