<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">تقييم الأداء</h1><p class="text-sm text-gray-500">عرض تقييمات الأداء والمقاييس</p></div>
                <a href="{{ route('employee.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            <!-- Performance Reviews -->
            <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">تقييمات الأداء</h3></div>
                @if($reviews->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد تقييمات بعد.</div>
                @else
                    <div class="divide-y divide-gray-200">
                        @foreach($reviews as $review)
                            <div class="p-6">
                                <div class="flex justify-between items-start flex-wrap gap-4">
                                    <div>
                                        <h4 class="font-medium text-gray-900">{{ $review->review_period ?? 'تقييم' }}</h4>
                                        <p class="text-sm text-gray-500">بواسطة: {{ $review->reviewer->name ?? 'غير محدد' }} — {{ $review->review_date?->format('Y-m-d') }}</p>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <div class="flex">
                                            @for($i = 1; $i <= 5; $i++)
                                                <svg class="w-5 h-5 {{ $i <= ($review->overall_rating ?? 0) ? 'text-yellow-400' : 'text-gray-300' }}" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                            @endfor
                                        </div>
                                        <span class="text-lg font-bold text-gray-700">{{ $review->overall_rating ?? '-' }}/5</span>
                                    </div>
                                </div>
                                @if($review->strengths)<div class="mt-3"><p class="text-xs font-medium text-green-700">نقاط القوة</p><p class="text-sm text-gray-600">{{ $review->strengths }}</p></div>@endif
                                @if($review->improvements)<div class="mt-2"><p class="text-xs font-medium text-orange-700">مجالات التحسين</p><p class="text-sm text-gray-600">{{ $review->improvements }}</p></div>@endif
                                @if($review->comments)<div class="mt-2"><p class="text-xs font-medium text-gray-500">ملاحظات</p><p class="text-sm text-gray-600">{{ $review->comments }}</p></div>@endif
                            </div>
                        @endforeach
                    </div>
                    <div class="p-4">{{ $reviews->links() }}</div>
                @endif
            </div>

            <!-- Metrics -->
            @if($metrics->count())
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b"><h3 class="text-lg font-medium">مقاييس الأداء</h3></div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 p-6">
                    @foreach($metrics as $metric)
                        <div class="border rounded-lg p-4">
                            <h4 class="font-medium text-gray-900 mb-1">{{ $metric->metric_name }}</h4>
                            <div class="flex items-center gap-2 mb-2">
                                <div class="flex-1 bg-gray-200 rounded-full h-2"><div class="bg-blue-600 h-2 rounded-full" style="width: {{ min(($metric->actual_value / max($metric->target_value, 1)) * 100, 100) }}%"></div></div>
                                <span class="text-sm font-bold">{{ $metric->actual_value }}/{{ $metric->target_value }}</span>
                            </div>
                            <p class="text-xs text-gray-500">{{ $metric->period ?? '-' }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</x-public-layout>
