<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">السلف</h1><p class="text-sm text-gray-500">طلبات السلفة المالية</p></div>
                <div class="flex gap-3">
                    <button onclick="document.getElementById('advanceModal').classList.remove('hidden')" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 text-sm">+ طلب سلفة</button>
                    <a href="{{ route('employee.dashboard') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 text-sm">← العودة</a>
                </div>
            </div>

            @if(session('success'))<div class="mb-4 p-3 bg-green-50 text-green-700 rounded-lg text-sm">{{ session('success') }}</div>@endif

            <div class="bg-white shadow rounded-lg overflow-hidden">
                @if($advances->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد طلبات سلف.</div>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50"><tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">التاريخ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المبلغ</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">السبب</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                            </tr></thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($advances as $adv)
                                    <tr>
                                        <td class="px-6 py-4 text-sm text-gray-500">{{ $adv->requested_date?->format('Y-m-d') ?? $adv->created_at->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4 text-sm font-bold">{{ number_format($adv->amount, 2) }} EGP</td>
                                        <td class="px-6 py-4 text-sm text-gray-600">{{ Str::limit($adv->reason, 50) }}</td>
                                        <td class="px-6 py-4"><span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $adv->status === 'APPROVED' ? 'bg-green-100 text-green-800' : ($adv->status === 'REJECTED' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $adv->status }}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4">{{ $advances->links() }}</div>
                @endif
            </div>
        </div>
    </div>

    <div id="advanceModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" onclick="if(event.target===this)this.classList.add('hidden')">
        <div class="relative top-20 mx-auto p-6 border w-full max-w-md shadow-lg rounded-md bg-white" dir="rtl">
            <h3 class="text-lg font-medium mb-4">طلب سلفة جديد</h3>
            <form method="POST" action="{{ route('employee.salary-advances.store') }}" class="space-y-4">@csrf
                <div><label class="block text-sm font-medium text-gray-700 mb-1">المبلغ (EGP)</label><input type="number" name="amount" min="100" step="50" required class="block w-full rounded-md border-gray-300 shadow-sm"></div>
                <div><label class="block text-sm font-medium text-gray-700 mb-1">السبب</label><textarea name="reason" rows="3" required class="block w-full rounded-md border-gray-300 shadow-sm"></textarea></div>
                <div class="flex justify-end space-x-2 space-x-reverse"><button type="button" onclick="this.closest('[id]').classList.add('hidden')" class="px-4 py-2 bg-gray-300 rounded">إلغاء</button><button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">إرسال</button></div>
            </form>
        </div>
    </div>
</x-public-layout>
