<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between mb-8">
                <div><h1 class="text-2xl font-bold text-gray-900">سجل التدريب</h1><p class="text-sm text-gray-500">جميع الدورات التدريبية</p></div>
                <a href="{{ route('employee.dashboard') }}" class="text-sm text-blue-600 hover:text-blue-800">← العودة للوحة التحكم</a>
            </div>

            <div class="bg-white shadow rounded-lg overflow-hidden">
                @if($records->isEmpty())
                    <div class="p-8 text-center text-gray-500">لا توجد سجلات تدريب.</div>
                @else
                    <div class="divide-y divide-gray-200">
                        @foreach($records as $record)
                            <div class="p-6">
                                <div class="flex justify-between items-start flex-wrap gap-4">
                                    <div>
                                        <h4 class="font-medium text-gray-900">{{ $record->training_name }}</h4>
                                        <p class="text-sm text-gray-500">{{ $record->provider ?? 'غير محدد' }} • {{ $record->training_type ?? 'تدريب عام' }}</p>
                                        <p class="text-xs text-gray-400 mt-1">{{ $record->start_date?->format('Y-m-d') }} — {{ $record->end_date?->format('Y-m-d') ?? 'مستمر' }}</p>
                                    </div>
                                    <div class="text-left">
                                        <span class="px-2.5 py-0.5 rounded-full text-xs font-medium {{ $record->status === 'COMPLETED' ? 'bg-green-100 text-green-800' : ($record->status === 'IN_PROGRESS' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800') }}">{{ $record->status }}</span>
                                        @if($record->score)<p class="text-sm font-bold text-gray-700 mt-2">الدرجة: {{ $record->score }}%</p>@endif
                                        @if($record->certificate_url)<a href="{{ $record->certificate_url }}" target="_blank" class="text-xs text-blue-600 hover:text-blue-800 mt-1 inline-block">📄 عرض الشهادة</a>@endif
                                    </div>
                                </div>
                                @if($record->description)<p class="text-sm text-gray-600 mt-3">{{ $record->description }}</p>@endif
                            </div>
                        @endforeach
                    </div>
                    <div class="p-4">{{ $records->links() }}</div>
                @endif
            </div>
        </div>
    </div>
</x-public-layout>
