<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $siteSettings->site_title ?? config('app.name', 'الحمد للسيارات') }} - لوحة التحكم</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        [x-cloak] { display: none !important; }
        body { font-family: 'Cairo', sans-serif; }
    </style>
</head>
<body class="font-sans antialiased text-slate-900 bg-slate-50">
    <div x-data="{ 
            isSidebarCollapsed: false, 
            isMobileSidebarOpen: false,
            expandedSections: ['المبيعات والعملاء', 'المخزون والعمليات'],
            toggleSection(section) {
                if (this.expandedSections.includes(section)) {
                    this.expandedSections = this.expandedSections.filter(s => s !== section);
                } else {
                    this.expandedSections.push(section);
                }
            }
         }" 
         class="min-h-screen bg-gradient-to-br from-slate-50 via-slate-50 to-blue-50/50 relative overflow-hidden">
        
        <!-- Ambient Background -->
        <div class="pointer-events-none absolute inset-0 bg-[radial-gradient(circle_at_20%_20%,rgba(10,26,63,0.03),transparent_35%),radial-gradient(circle_at_80%_0%,rgba(193,39,45,0.03),transparent_30%)]"></div>

        <!-- Header -->
        <header class="sticky top-0 z-40 border-b border-white/80 bg-white/80 shadow-[0_16px_60px_rgba(15,23,42,0.08)] backdrop-blur-xl">
            <div class="px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <!-- Mobile Menu Trigger -->
                    <div class="flex items-center">
                        <button @click="isMobileSidebarOpen = true" class="md:hidden p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-blue-500">
                            <x-icon name="Menu" class="h-6 w-6" />
                        </button>
                    </div>

                    <!-- Desktop Search -->
                    <div class="hidden md:flex flex-1 max-w-xl mx-4">
                        <div class="relative w-full overflow-hidden rounded-full border border-blue-100/80 bg-gradient-to-r from-white to-blue-50/60 shadow-inner shadow-blue-100/60 transition-all focus-within:ring-2 focus-within:ring-blue-500/20 focus-within:border-blue-400">
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                <x-icon name="Search" class="h-4 w-4 text-blue-500" />
                            </div>
                            <input type="text" 
                                   class="block w-full pr-10 pl-4 py-2 border-none bg-transparent placeholder-gray-400 focus:ring-0 sm:text-sm" 
                                   placeholder="ابحث عن سيارات، عملاء، حجوزات...">
                        </div>
                    </div>

                    <!-- Right Actions -->
                    <div class="flex items-center space-x-2 space-x-reverse sm:space-x-4 sm:space-x-reverse">
                        <!-- Notifications (Simplified) -->
                        <button class="p-2 text-gray-400 hover:text-blue-600 transition-colors relative">
                            <span class="absolute top-2 left-2 block h-2 w-2 rounded-full bg-red-500 ring-2 ring-white"></span>
                            <x-icon name="Bell" class="h-6 w-6" />
                        </button>

                        <a href="{{ route('home') }}" target="_blank" class="hidden sm:inline-flex items-center px-4 py-2 border border-blue-100/80 shadow-sm text-sm font-medium rounded-full text-blue-700 bg-gradient-to-r from-white to-blue-50/60 hover:bg-blue-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            الذهاب للموقع
                        </a>

                        <!-- User Dropdown -->
                        <div x-data="{ open: false }" class="relative ml-3">
                            <div>
                                <button @click="open = !open" type="button" class="flex items-center max-w-xs text-sm rounded-full focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500" id="user-menu-button" aria-expanded="false" aria-haspopup="true">
                                    <span class="sr-only">Open user menu</span>
                                    <div class="flex items-center gap-3 bg-white/50 p-1 pl-4 rounded-full border border-blue-100/50 hover:bg-white transition-colors">
                                        <div class="h-9 w-9 rounded-full bg-gradient-to-br from-blue-600 to-indigo-500 text-white flex items-center justify-center shadow-lg ring-2 ring-blue-100">
                                            <span class="font-bold text-sm">{{ substr(Auth::user()->name, 0, 1) }}</span>
                                        </div>
                                        <div class="hidden md:block text-right">
                                            <p class="text-sm font-bold text-slate-900 truncate max-w-[100px]">{{ Auth::user()->name }}</p>
                                            <p class="text-xs text-blue-600 font-medium">{{ Auth::user()->role }}</p>
                                        </div>
                                        <x-icon name="ChevronDown" class="h-4 w-4 text-gray-400 hidden md:block" />
                                    </div>
                                </button>
                            </div>
                            <div x-show="open" 
                                 @click.away="open = false"
                                 x-transition:enter="transition ease-out duration-100"
                                 x-transition:enter-start="transform opacity-0 scale-95"
                                 x-transition:enter-end="transform opacity-100 scale-100"
                                 x-transition:leave="transition ease-in duration-75"
                                 x-transition:leave-start="transform opacity-100 scale-100"
                                 x-transition:leave-end="transform opacity-0 scale-95"
                                 class="origin-top-left absolute left-0 mt-2 w-48 rounded-md shadow-lg py-1 bg-white ring-1 ring-black ring-opacity-5 focus:outline-none z-50">
                                <div class="px-4 py-2 border-b border-gray-100 md:hidden">
                                     <p class="text-sm font-medium text-gray-900">{{ Auth::user()->name }}</p>
                                     <p class="text-xs text-gray-500">{{ Auth::user()->email }}</p>
                                </div>
                                <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">الإعدادات</a>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="block w-full text-right px-4 py-2 text-sm text-red-600 hover:bg-red-50">تسجيل الخروج</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <div class="flex h-[calc(100vh-64px)] overflow-hidden">
            <!-- Sidebar (Desktop) -->
            <aside :class="isSidebarCollapsed ? 'w-20' : 'w-72'" class="hidden md:flex flex-col bg-white border-l border-gray-200 transition-all duration-300 ease-in-out relative z-30">
                <div class="flex items-center justify-between h-16 px-4 border-b border-gray-100">
                    <div class="flex items-center gap-3 overflow-hidden" x-show="!isSidebarCollapsed">
                         <div class="flex items-center justify-center h-8 w-8 rounded-lg bg-red-600 text-white">
                            <x-icon name="Car" class="h-5 w-5" />
                         </div>
                         <span class="text-lg font-bold text-slate-900 whitespace-nowrap">الحمد للسيارات</span>
                    </div>
                    <div x-show="isSidebarCollapsed" class="w-full flex justify-center">
                         <div class="flex items-center justify-center h-8 w-8 rounded-lg bg-red-600 text-white">
                            <x-icon name="Car" class="h-5 w-5" />
                         </div>
                    </div>
                    <button @click="isSidebarCollapsed = !isSidebarCollapsed" class="p-1.5 rounded-lg text-gray-400 hover:text-gray-600 hover:bg-gray-100">
                        <x-icon name="ChevronRight" class="h-4 w-4" x-show="!isSidebarCollapsed" />
                        <x-icon name="ChevronLeft" class="h-4 w-4" x-show="isSidebarCollapsed" />
                    </button>
                </div>

                <nav class="flex-1 overflow-y-auto p-4 space-y-2 scrollbar-thin scrollbar-thumb-gray-200">
                    <!-- Dashboard -->
                    <a href="{{ route('admin.dashboard') }}" 
                       class="flex items-center gap-3 px-3 py-2.5 rounded-xl transition-all duration-200 group {{ request()->routeIs('admin.dashboard') ? 'bg-blue-50 text-blue-700 shadow-sm border border-blue-100' : 'text-slate-600 hover:bg-slate-50 hover:text-slate-900' }}">
                        <x-icon name="LayoutDashboard" class="h-5 w-5 {{ request()->routeIs('admin.dashboard') ? 'text-blue-600' : 'text-slate-400 group-hover:text-slate-600' }}" />
                        <span x-show="!isSidebarCollapsed" class="font-bold text-sm">لوحة التحكم</span>
                    </a>

                    <!-- Sales & Customers Section -->
                    <div x-show="!isSidebarCollapsed" class="pt-4 pb-2">
                        <button @click="toggleSection('المبيعات والعملاء')" class="w-full flex items-center justify-between px-3 py-1 text-xs font-bold text-gray-400 uppercase tracking-wider hover:text-gray-600">
                            <span>المبيعات والعملاء</span>
                            <x-icon name="ChevronDown" class="h-3 w-3 transition-transform duration-200" ::class="expandedSections.includes('المبيعات والعملاء') ? 'transform rotate-180' : ''" />
                        </button>
                    </div>
                    <div x-show="isSidebarCollapsed || expandedSections.includes('المبيعات والعملاء')" class="space-y-1" :class="isSidebarCollapsed ? '' : 'pr-2'">
                         <a href="{{ route('admin.bookings.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.bookings.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Calendar" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">الحجوزات</span>
                        </a>
                        <a href="{{ route('admin.crm.customers.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.crm.customers.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="UserPlus" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">العملاء</span>
                        </a>
                        <a href="{{ route('admin.quotations.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.quotations.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="FileCheck" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">عروض الأسعار</span>
                        </a>
                         <a href="{{ route('admin.sales') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.sales') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="DollarSign" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">المبيعات</span>
                        </a>
                    </div>

                    <!-- Inventory & Ops Section -->
                    <div x-show="!isSidebarCollapsed" class="pt-4 pb-2">
                        <button @click="toggleSection('المخزون والعمليات')" class="w-full flex items-center justify-between px-3 py-1 text-xs font-bold text-gray-400 uppercase tracking-wider hover:text-gray-600">
                            <span>المخزون والعمليات</span>
                            <x-icon name="ChevronDown" class="h-3 w-3 transition-transform duration-200" ::class="expandedSections.includes('المخزون والعمليات') ? 'transform rotate-180' : ''" />
                        </button>
                    </div>
                    <div x-show="isSidebarCollapsed || expandedSections.includes('المخزون والعمليات')" class="space-y-1" :class="isSidebarCollapsed ? '' : 'pr-2'">
                        <a href="{{ route('admin.vehicles.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.vehicles.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Car" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">المركبات</span>
                        </a>
                         <a href="{{ route('admin.maintenance-admin') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.maintenance-admin') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Wrench" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">الصيانة</span>
                        </a>
                        <a href="{{ route('admin.service-types.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.service-types.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Settings" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">أنواع الخدمات</span>
                        </a>
                    </div>

                    <!-- HR Section -->
                    <div x-show="!isSidebarCollapsed" class="pt-4 pb-2">
                        <button @click="toggleSection('الموارد البشرية')" class="w-full flex items-center justify-between px-3 py-1 text-xs font-bold text-gray-400 uppercase tracking-wider hover:text-gray-600">
                            <span>الموارد البشرية</span>
                            <x-icon name="ChevronDown" class="h-3 w-3 transition-transform duration-200" ::class="expandedSections.includes('الموارد البشرية') ? 'transform rotate-180' : ''" />
                        </button>
                    </div>
                     <div x-show="isSidebarCollapsed || expandedSections.includes('الموارد البشرية')" class="space-y-1" :class="isSidebarCollapsed ? '' : 'pr-2'">
                        <a href="{{ route('admin.hr.employees.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.hr.employees.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="UserCheck" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">الموظفون</span>
                        </a>
                        <a href="{{ route('admin.hr.attendance') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.hr.attendance') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Clock" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">الحضور</span>
                        </a>
                         <a href="{{ route('admin.hr.leaves') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.hr.leaves') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Calendar" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">الإجازات</span>
                        </a>
                    </div>

                     <!-- Finance Section -->
                     <div x-show="!isSidebarCollapsed" class="pt-4 pb-2">
                        <button @click="toggleSection('المالية')" class="w-full flex items-center justify-between px-3 py-1 text-xs font-bold text-gray-400 uppercase tracking-wider hover:text-gray-600">
                             <span>المالية والحسابات</span>
                            <x-icon name="ChevronDown" class="h-3 w-3 transition-transform duration-200" ::class="expandedSections.includes('المالية') ? 'transform rotate-180' : ''" />
                        </button>
                    </div>
                    <div x-show="isSidebarCollapsed || expandedSections.includes('المالية')" class="space-y-1" :class="isSidebarCollapsed ? '' : 'pr-2'">
                        <a href="{{ route('admin.finance.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.finance.index') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="CreditCard" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">الفواتير</span>
                        </a>
                        <a href="{{ route('admin.accounting.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.accounting.index') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Calculator" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">المحاسبة</span>
                        </a>
                    </div>

                    <!-- System Section -->
                     <div x-show="!isSidebarCollapsed" class="pt-4 pb-2">
                        <button @click="toggleSection('النظام')" class="w-full flex items-center justify-between px-3 py-1 text-xs font-bold text-gray-400 uppercase tracking-wider hover:text-gray-600">
                             <span>النظام والإعدادات</span>
                            <x-icon name="ChevronDown" class="h-3 w-3 transition-transform duration-200" ::class="expandedSections.includes('النظام') ? 'transform rotate-180' : ''" />
                        </button>
                    </div>
                    <div x-show="isSidebarCollapsed || expandedSections.includes('النظام')" class="space-y-1" :class="isSidebarCollapsed ? '' : 'pr-2'">
                         <a href="{{ route('admin.cms.settings.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.cms.settings.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Layout" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">إعدادات الموقع</span>
                        </a>
                        <a href="{{ route('admin.users.index') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.users.*') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="Users" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">المستخدمون</span>
                        </a>
                        <a href="{{ route('admin.activity-logs') }}" class="flex items-center gap-3 px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.activity-logs') ? 'bg-blue-50 text-blue-700' : 'text-gray-600 hover:bg-gray-50' }}">
                            <x-icon name="FileText" class="h-4 w-4" />
                            <span x-show="!isSidebarCollapsed">سجل النشاطات</span>
                        </a>
                    </div>
                <div class="border-t border-gray-100 p-4">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="flex w-full items-center gap-3 px-3 py-2 text-sm font-medium text-red-600 rounded-lg hover:bg-red-50 transition-colors">
                            <x-icon name="LogOut" class="h-5 w-5" />
                            <span x-show="!isSidebarCollapsed">تسجيل الخروج</span>
                        </button>
                    </form>
                </div>
            </aside>

            <!-- Main Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto p-4 md:p-8">
                <div class="mx-auto w-full max-w-7xl space-y-4 rounded-3xl border border-white/40 bg-white/60 p-6 shadow-2xl shadow-slate-200/50 backdrop-blur-2xl min-h-[calc(100vh-8rem)]">
                     <!-- Flash Messages -->
                    @if (session('success'))
                        <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)" class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-xl relative mb-6 flex items-center gap-3" role="alert">
                            <x-icon name="CheckCircle" class="h-5 w-5 text-green-600" />
                            <span class="block sm:inline font-medium">{{ session('success') }}</span>
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-xl relative mb-6" role="alert">
                            <ul class="list-disc list-inside text-sm">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{ $slot }}
                </div>
            </main>
        </div>

        <!-- Mobile Sidebar Overlay -->
        <div x-show="isMobileSidebarOpen" 
             style="display: none;"
             class="fixed inset-0 z-50 flex bg-black/50 backdrop-blur-sm md:hidden"
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0">
             
            <div class="relative w-80 bg-white h-full shadow-2xl flex flex-col"
                 @click.away="isMobileSidebarOpen = false"
                 x-transition:enter="transition ease-in-out duration-300 transform"
                 x-transition:enter-start="translate-x-full"
                 x-transition:enter-end="translate-x-0"
                 x-transition:leave="transition ease-in-out duration-300 transform"
                 x-transition:leave-start="translate-x-0"
                 x-transition:leave-end="translate-x-full">
                 
                 <div class="flex items-center justify-between p-4 border-b border-gray-100">
                    <span class="text-xl font-bold text-gray-900">القائمة</span>
                    <button @click="isMobileSidebarOpen = false" class="p-2 -mr-2 text-gray-400 hover:text-gray-500">
                        <x-icon name="X" class="h-6 w-6" />
                    </button>
                 </div>

                 <nav class="flex-1 overflow-y-auto p-4 space-y-2">
                     <!-- Same navigation items as desktop, but always expanded or simple list -->
                     <a href="{{ route('admin.dashboard') }}" class="block px-3 py-2 rounded-lg text-base font-medium text-gray-900 hover:bg-gray-50">لوحة التحكم</a>
                     
                     <div class="pt-2 pb-1 border-t border-gray-100 mt-2">
                         <span class="text-xs font-semibold text-gray-400 uppercase">المبيعات والعملاء</span>
                     </div>
                     <a href="{{ route('admin.bookings.index') }}" class="block px-3 py-2 rounded-lg text-base font-medium text-gray-600 hover:text-gray-900 hover:bg-gray-50">الحجوزات</a>
                     <a href="{{ route('admin.crm.customers.index') }}" class="block px-3 py-2 rounded-lg text-base font-medium text-gray-600 hover:text-gray-900 hover:bg-gray-50">العملاء</a>
                     
                     <div class="pt-2 pb-1 border-t border-gray-100 mt-2">
                         <span class="text-xs font-semibold text-gray-400 uppercase">المخزون والعمليات</span>
                     </div>
                     <a href="{{ route('admin.vehicles.index') }}" class="block px-3 py-2 rounded-lg text-base font-medium text-gray-600 hover:text-gray-900 hover:bg-gray-50">المركبات</a>

                     <!-- Add more mobile links as needed -->
                 </nav>
            </div>
        </div>
    </div>
</body>
</html>
