<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>فاتورة {{ $invoice->invoice_number }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; color: #1a1a2e; direction: rtl; padding: 30px; }
        .header { display: flex; justify-content: space-between; border-bottom: 3px solid #c8a45a; padding-bottom: 15px; margin-bottom: 20px; }
        .company-name { font-size: 22px; font-weight: bold; color: #c8a45a; }
        .company-details { font-size: 10px; color: #666; margin-top: 5px; }
        .invoice-title { text-align: center; font-size: 18px; font-weight: bold; color: #1a1a2e; margin: 15px 0; background: #f5f0e6; padding: 8px; border-radius: 4px; }
        .meta-table { width: 100%; margin-bottom: 20px; }
        .meta-table td { padding: 5px 10px; font-size: 11px; }
        .meta-table .label { font-weight: bold; color: #555; width: 120px; }
        table.items { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        table.items th { background: #1a1a2e; color: #c8a45a; padding: 8px 10px; text-align: right; font-size: 11px; }
        table.items td { padding: 8px 10px; border-bottom: 1px solid #eee; font-size: 11px; }
        table.items tr:nth-child(even) { background: #fafafa; }
        .totals { width: 300px; margin-right: auto; }
        .totals td { padding: 5px 10px; }
        .totals .total-row { font-size: 14px; font-weight: bold; color: #c8a45a; border-top: 2px solid #1a1a2e; }
        .footer { margin-top: 30px; text-align: center; font-size: 10px; color: #999; border-top: 1px solid #ddd; padding-top: 10px; }
        .status { display: inline-block; padding: 3px 10px; border-radius: 3px; font-size: 10px; font-weight: bold; }
        .status-paid { background: #d4edda; color: #155724; }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-overdue { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="header">
        <div>
            <div class="company-name">الحمد للسيارات</div>
            <div class="company-details">
                القاهرة، مصر<br>
                هاتف: 01000000000<br>
                البريد: info@elhamd-cars.com
            </div>
        </div>
        <div style="text-align: left;">
            <div style="font-size: 14px; font-weight: bold;">فاتورة رقم</div>
            <div style="font-size: 16px; color: #c8a45a; font-weight: bold;">{{ $invoice->invoice_number }}</div>
            <div style="font-size: 10px; color: #666; margin-top: 5px;">
                تاريخ الإصدار: {{ $invoice->issue_date?->format('Y-m-d') }}<br>
                تاريخ الاستحقاق: {{ $invoice->due_date?->format('Y-m-d') }}
            </div>
        </div>
    </div>

    <div class="invoice-title">
        فاتورة {{ $invoice->type }}
        <span class="status {{ $invoice->status === 'PAID' ? 'status-paid' : ($invoice->status === 'OVERDUE' ? 'status-overdue' : 'status-pending') }}">
            {{ $invoice->status }}
        </span>
    </div>

    <table class="meta-table">
        <tr>
            <td class="label">العميل:</td>
            <td>{{ $invoice->customer?->name ?? '-' }}</td>
            <td class="label">البريد الإلكتروني:</td>
            <td>{{ $invoice->customer?->email ?? '-' }}</td>
        </tr>
        <tr>
            <td class="label">الهاتف:</td>
            <td>{{ $invoice->customer?->phone ?? '-' }}</td>
            @if($invoice->vehicle)
                <td class="label">السيارة:</td>
                <td>{{ $invoice->vehicle->make }} {{ $invoice->vehicle->model }} {{ $invoice->vehicle->year }}</td>
            @else
                <td colspan="2"></td>
            @endif
        </tr>
    </table>

    @if($invoice->items && $invoice->items->count())
        <table class="items">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الوصف</th>
                    <th>الكمية</th>
                    <th>سعر الوحدة</th>
                    <th>الإجمالي</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $index => $item)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $item->description }}</td>
                        <td>{{ $item->quantity }}</td>
                        <td>{{ number_format($item->unit_price, 2) }} ج.م</td>
                        <td>{{ number_format($item->total, 2) }} ج.م</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    <table class="totals">
        <tr>
            <td class="label">المجموع الفرعي:</td>
            <td style="text-align: left;">{{ number_format($invoice->subtotal, 2) }} ج.م</td>
        </tr>
        @if($invoice->discount_amount > 0)
            <tr>
                <td class="label">الخصم:</td>
                <td style="text-align: left; color: #dc3545;">-{{ number_format($invoice->discount_amount, 2) }} ج.م</td>
            </tr>
        @endif
        <tr>
            <td class="label">الضريبة:</td>
            <td style="text-align: left;">{{ number_format($invoice->tax_amount, 2) }} ج.م</td>
        </tr>
        <tr class="total-row">
            <td class="label">الإجمالي:</td>
            <td style="text-align: left;">{{ number_format($invoice->total_amount, 2) }} ج.م</td>
        </tr>
        <tr>
            <td class="label">المدفوع:</td>
            <td style="text-align: left; color: #28a745;">{{ number_format($invoice->paid_amount, 2) }} ج.م</td>
        </tr>
        @if($invoice->total_amount - $invoice->paid_amount > 0)
            <tr>
                <td class="label" style="color: #dc3545;">المتبقي:</td>
                <td style="text-align: left; color: #dc3545; font-weight: bold;">{{ number_format($invoice->total_amount - $invoice->paid_amount, 2) }} ج.م</td>
            </tr>
        @endif
    </table>

    @if($invoice->notes)
        <div style="margin-top: 20px; padding: 10px; background: #f8f9fa; border-radius: 4px;">
            <strong>ملاحظات:</strong> {{ $invoice->notes }}
        </div>
    @endif

    <div class="footer">
        تم إنشاء هذه الفاتورة إلكترونياً بواسطة نظام الحمد للسيارات &bull; {{ now()->format('Y-m-d H:i') }}
    </div>
</body>
</html>
