<x-public-layout>
    <div class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <h1 class="text-4xl font-bold mb-8 text-center">{{ $companyInfo->name ?? 'عن شركة ' . ($siteSettings->site_title ?? 'الحمد') }}</h1>
            
            <div class="prose prose-lg mx-auto text-gray-600">
                <p class="lead text-xl text-center mb-12">
                    {{ $companyInfo->description }}
                </p>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center mb-16">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900 mb-4">تاريخنا</h2>
                        @foreach($timeline as $event)
                        <div class="mb-4">
                            <h3 class="font-bold text-gray-800">{{ $event->title }} ({{ \Carbon\Carbon::parse($event->event_date)->year }})</h3>
                            <p>{{ $event->description }}</p>
                        </div>
                        @endforeach
                    </div>
                    <div class="rounded-2xl overflow-hidden shadow-xl">
                        <img src="{{ asset('uploads/showroom-luxury.jpg') }}" alt="{{ $siteSettings->site_title ?? 'معرض الحمد' }}" class="w-full h-full object-cover">
                    </div>
                </div>

                <div class="text-center mb-16">
                    <h2 class="text-2xl font-bold text-gray-900 mb-8">لماذا تختارنا؟</h2>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                        @foreach($values as $value)
                            <div class="p-6 bg-gray-50 rounded-xl">
                                <div class="flex justify-center mb-4">
                                    <i class="{{ $value->icon ?? 'fas fa-check' }} text-3xl text-blue-600"></i>
                                </div>
                                <h3 class="font-bold text-lg mb-2">{{ $value->title }}</h3>
                                <p class="text-sm">{{ $value->description }}</p>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-public-layout>
