<x-public-layout>
    <div x-data="{ activeTab: 'test-drive' }">
        <!-- Header -->
        <div class="bg-gradient-to-r from-blue-900 to-blue-700 text-white">
            <div class="container mx-auto px-4 py-12">
                <div class="max-w-4xl mx-auto">
                    <a href="/" class="inline-flex items-center text-blue-200 hover:text-white mb-6 transition-colors">
                        <x-icon name="ArrowRight" class="ml-2 h-4 w-4" />
                        العودة للرئيسية
                    </a>
                    <div class="text-center">
                        <h1 class="text-4xl md:text-5xl font-bold mb-6">
                            مركز الحجز
                        </h1>
                        <p class="text-xl text-blue-100 mb-8">
                            احجز تجربة قيادة أو موعد صيانة لسيارتك تاتا
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="container mx-auto px-4 py-8">
            <div class="max-w-4xl mx-auto">
                <!-- Tabs Navigation -->
                <div class="w-full mb-8 border-b border-gray-200">
                    <div class="grid w-full grid-cols-2">
                        <button @click="activeTab = 'test-drive'" :class="{ 'border-blue-600 text-blue-600': activeTab === 'test-drive', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'test-drive' }" class="py-4 px-1 text-center border-b-2 font-medium text-sm flex items-center justify-center gap-2 transition-colors">
                            <x-icon name="Car" class="h-4 w-4" />
                            تجربة قيادة
                        </button>
                        <button @click="activeTab = 'service'" :class="{ 'border-blue-600 text-blue-600': activeTab === 'service', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'service' }" class="py-4 px-1 text-center border-b-2 font-medium text-sm flex items-center justify-center gap-2 transition-colors">
                            <x-icon name="Wrench" class="h-4 w-4" />
                            حجز صيانة
                        </button>
                    </div>
                </div>

                <!-- Test Drive Tab -->
                <div x-show="activeTab === 'test-drive'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden">
                    <div class="p-6 border-b border-gray-100">
                        <h3 class="flex items-center gap-2 text-xl font-bold text-gray-900">
                            <x-icon name="Car" class="h-5 w-5 text-blue-600" />
                            احجز تجربة قيادة
                        </h3>
                        <p class="text-gray-500 text-sm mt-1">
                            جرب بنفسك قيادة سيارات تاتا واختبر أدائها وجودتها
                        </p>
                    </div>
                    <div class="p-6 space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-4">
                                <h3 class="font-semibold text-lg text-gray-900">لماذا تجربة القيادة؟</h3>
                                <ul class="space-y-2">
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        اختبر أداء السيارة بشكل عملي
                                    </li>
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        تعرف على مميزات السيارة الداخلية
                                    </li>
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        استشر مع مندوبينا المتخصصين
                                    </li>
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        قارن بين الموديلات المختلفة
                                    </li>
                                </ul>
                            </div>
                            <div class="space-y-4">
                                <h3 class="font-semibold text-lg text-gray-900">معلومات الحجز</h3>
                                <div class="space-y-3">
                                    <div class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="Clock" class="h-4 w-4 text-gray-400" />
                                        <span>المدة: 30 - 45 دقيقة</span>
                                    </div>
                                    <div class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="MapPin" class="h-4 w-4 text-gray-400" />
                                        <span>الموقع: القاهرة، مصر</span>
                                    </div>
                                    <div class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="Phone" class="h-4 w-4 text-gray-400" />
                                        <span class="dir-ltr text-right">للحجز: +20 155 576 7729</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center pt-4">
                            <a href="{{ route('public.test-drive') }}" class="inline-flex items-center justify-center px-8 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg text-lg font-semibold transition-colors gap-2">
                                <x-icon name="Calendar" class="h-5 w-5" />
                                احجز تجربة قيادة الآن
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Service Booking Tab -->
                <div x-show="activeTab === 'service'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden" style="display: none;">
                    <div class="p-6 border-b border-gray-100">
                        <h3 class="flex items-center gap-2 text-xl font-bold text-gray-900">
                            <x-icon name="Wrench" class="h-5 w-5 text-blue-600" />
                            حجز موعد صيانة
                        </h3>
                        <p class="text-gray-500 text-sm mt-1">
                            احجز موعداً لصيانة سيارتك تاتا مع فنيين معتمدين وقطع غيار أصلية
                        </p>
                    </div>
                    <div class="p-6 space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-4">
                                <h3 class="font-semibold text-lg text-gray-900">خدماتنا</h3>
                                <div class="flex flex-wrap gap-2">
                                    <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-sm">صيانة دورية</span>
                                    <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-sm">إصلاح عام</span>
                                    <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-sm">فحص شامل</span>
                                    <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-sm">تغيير زيت</span>
                                    <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-sm">صيانة مكيف</span>
                                    <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-sm">فحص فرامل</span>
                                </div>
                            </div>
                            <div class="space-y-4">
                                <h3 class="font-semibold text-lg text-gray-900">مميزاتنا</h3>
                                <ul class="space-y-2">
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        فنيون معتمدون من تاتا
                                    </li>
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        قطع غيار أصلية فقط
                                    </li>
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        ضمان على جميع الخدمات
                                    </li>
                                    <li class="flex items-center gap-2 text-gray-600">
                                        <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                        خدمة سيارة بديلة
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="text-center pt-4">
                            <a href="{{ route('public.service-booking') }}" class="inline-flex items-center justify-center px-8 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg text-lg font-semibold transition-colors gap-2">
                                <x-icon name="Calendar" class="h-5 w-5" />
                                احجز موعد صيانة الآن
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-public-layout>
