<x-public-layout>
    @section('title', 'طلب استشارة')

    <div class="min-h-screen bg-[#0F172A] relative flex items-center justify-center py-20 overflow-hidden">
        <!-- Background Effects -->
        <div class="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/carbon-fibre.png')] opacity-20"></div>
        <div class="absolute top-0 right-0 w-1/2 h-full bg-gradient-to-l from-red-600/10 to-transparent"></div>
        <div class="absolute bottom-0 left-0 w-1/2 h-full bg-gradient-to-r from-blue-600/10 to-transparent"></div>

        <div class="max-w-4xl w-full mx-auto px-4 relative z-10">
            <div class="text-center mb-12">
                <span class="inline-block py-1 px-3 rounded-full bg-red-500/20 text-red-300 text-sm font-bold border border-red-500/30 mb-4 backdrop-blur-sm">
                    خدمة مميزة
                </span>
                <h1 class="text-4xl md:text-5xl font-black text-white mb-4">طلب استشارة متخصصة</h1>
                <p class="text-xl text-slate-400 font-light">
                    خبراؤنا جاهزون لمساعدتك في اختيار الحل الأمثل لأسطولك التجاري
                </p>
            </div>

            <div class="bg-white rounded-3xl shadow-2xl overflow-hidden flex flex-col md:flex-row">
                <!-- Visual Side -->
                <div class="hidden md:block w-1/3 bg-slate-900 relative">
                    <img src="/assets/images/consultation-bg.jpg" class="w-full h-full object-cover opacity-60 mix-blend-overlay" onerror="this.src='https://placehold.co/400x800/1e293b/FFF?text=Consultation'">
                    <div class="absolute inset-0 p-8 flex flex-col justify-end bg-gradient-to-t from-black/80 to-transparent">
                        <div class="space-y-4">
                            <div class="flex items-center gap-3 text-white/90">
                                <svg class="w-5 h-5 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                <span class="font-medium">تحليل احتياجات الأسطول</span>
                            </div>
                            <div class="flex items-center gap-3 text-white/90">
                                <svg class="w-5 h-5 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                <span class="font-medium">حلول تمويلية مخصصة</span>
                            </div>
                            <div class="flex items-center gap-3 text-white/90">
                                <svg class="w-5 h-5 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                <span class="font-medium">دعم فني ولوجستي</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Side -->
                <div class="w-full md:w-2/3 p-8 md:p-12 bg-white">
                    @if(session('success'))
                        <div class="mb-8 bg-emerald-50 border border-emerald-200 text-emerald-700 px-6 py-4 rounded-xl flex items-center gap-3">
                            <svg class="w-6 h-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                            <p class="font-bold">{{ session('success') }}</p>
                        </div>
                    @endif

                    <form action="{{ route('consultation.submit') }}" method="POST" class="space-y-6">
                        @csrf
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-bold text-slate-700 mb-2">الاسم بالكامل</label>
                                <input type="text" name="name" required class="w-full h-12 px-4 rounded-xl border-slate-200 bg-slate-50 focus:border-blue-500 focus:ring-blue-500/20 transition-all font-medium">
                            </div>
                            <div>
                                <label class="block text-sm font-bold text-slate-700 mb-2">رقم الهاتف</label>
                                <input type="tel" name="phone" required class="w-full h-12 px-4 rounded-xl border-slate-200 bg-slate-50 focus:border-blue-500 focus:ring-blue-500/20 transition-all font-medium text-left dir-ltr">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">نوع الاستشارة</label>
                            <div class="grid grid-cols-2 gap-4">
                                <label class="cursor-pointer">
                                    <input type="radio" name="topic" value="شراء شاحنات" class="peer sr-only" checked>
                                    <div class="p-4 rounded-xl border border-slate-200 bg-slate-50 peer-checked:bg-blue-50 peer-checked:border-blue-500 peer-checked:text-blue-700 transition-all text-center">
                                        <span class="font-bold block">شراء شاحنات</span>
                                    </div>
                                </label>
                                <label class="cursor-pointer">
                                    <input type="radio" name="topic" value="عقود صيانة" class="peer sr-only">
                                    <div class="p-4 rounded-xl border border-slate-200 bg-slate-50 peer-checked:bg-blue-50 peer-checked:border-blue-500 peer-checked:text-blue-700 transition-all text-center">
                                        <span class="font-bold block">عقود صيانة</span>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">تفاصيل إضافية</label>
                            <textarea name="details" rows="3" class="w-full p-4 rounded-xl border-slate-200 bg-slate-50 focus:border-blue-500 focus:ring-blue-500/20 transition-all font-medium resize-none" placeholder="أخبرنا المزيد عن احتياجاتك..."></textarea>
                        </div>

                        <div class="pt-4">
                            <button type="submit" class="w-full py-4 bg-slate-900 hover:bg-slate-800 text-white font-bold rounded-xl shadow-lg transition-all transform hover:-translate-y-1 flex items-center justify-center gap-2">
                                <span>حجز موعد استشارة</span>
                                <svg class="w-5 h-5 rtl:rotate-180" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6" /></svg>
                            </button>
                            <p class="text-center text-xs text-slate-400 mt-4">سيقوم أحد ممثلينا بالتواصل معك خلال 24 ساعة</p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-public-layout>
