<x-public-layout>
    @section('title', 'اتصل بنا')
    
    <!-- Hero Section -->
    <div class="relative py-20 bg-[#0F172A] overflow-hidden">
        <div class="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/carbon-fibre.png')] opacity-20"></div>
        <div class="absolute inset-0 bg-gradient-to-t from-[#0F172A] via-transparent to-transparent"></div>
        
        <div class="max-w-7xl mx-auto px-4 relative z-10 text-center">
            <span class="inline-block py-1 px-3 rounded-full bg-blue-500/20 text-blue-300 text-sm font-bold border border-blue-500/30 mb-4 backdrop-blur-sm">
                نحن هنا للمساعدة
            </span>
            <h1 class="text-4xl md:text-5xl font-black text-white mb-6">اتصل بنا</h1>
            <p class="text-xl text-slate-400 max-w-2xl mx-auto font-light leading-relaxed">
                فريق خدمة العملاء جاهز للإجابة على استفساراتكم ومساعدتكم في اختيار السيارة المناسبة لاحتياجاتكم
            </p>
        </div>
    </div>

    <div class="py-16 bg-slate-50 relative">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 -mt-20 relative z-20">
                <!-- Info Cards -->
                <div class="lg:col-span-1 space-y-6">
                    <!-- Address Card -->
                    <div class="bg-white p-8 rounded-2xl shadow-xl shadow-slate-200/50 border border-slate-100 hover:-translate-y-1 transition-transform duration-300 group">
                        <div class="w-12 h-12 bg-blue-50 rounded-xl flex items-center justify-center text-blue-600 mb-4 group-hover:bg-blue-600 group-hover:text-white transition-colors">
                            <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                        </div>
                        <h3 class="font-bold text-slate-900 text-lg mb-2">العنوان</h3>
                        <p class="text-slate-600 leading-relaxed">{{ $contactInfo->address }}</p>
                    </div>

                    <!-- Phone Card -->
                    <div class="bg-white p-8 rounded-2xl shadow-xl shadow-slate-200/50 border border-slate-100 hover:-translate-y-1 transition-transform duration-300 group">
                        <div class="w-12 h-12 bg-red-50 rounded-xl flex items-center justify-center text-red-600 mb-4 group-hover:bg-red-600 group-hover:text-white transition-colors">
                             <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" /></svg>
                        </div>
                        <h3 class="font-bold text-slate-900 text-lg mb-2">الهاتف</h3>
                        <p class="text-slate-600 font-mono text-lg dir-ltr">{{ $contactInfo->primary_phone }}</p>
                    </div>

                    <!-- Email Card -->
                    <div class="bg-white p-8 rounded-2xl shadow-xl shadow-slate-200/50 border border-slate-100 hover:-translate-y-1 transition-transform duration-300 group">
                        <div class="w-12 h-12 bg-emerald-50 rounded-xl flex items-center justify-center text-emerald-600 mb-4 group-hover:bg-emerald-600 group-hover:text-white transition-colors">
                            <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" /></svg>
                        </div>
                        <h3 class="font-bold text-slate-900 text-lg mb-2">البريد الإلكتروني</h3>
                        <p class="text-slate-600 font-medium">{{ $contactInfo->primary_email }}</p>
                    </div>
                </div>

                <!-- Form & Map -->
                <div class="lg:col-span-2 space-y-8">
                    <!-- Contact Form -->
                    <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 border border-slate-100 overflow-hidden">
                        <div class="p-8 md:p-12">
                            <h2 class="text-2xl font-bold text-slate-900 mb-6 flex items-center gap-3">
                                <span class="w-2 h-8 bg-red-600 rounded-full"></span>
                                أرسل لنا رسالة
                            </h2>
                            
                            @if(session('success'))
                                <div class="mb-8 bg-emerald-50 border border-emerald-200 text-emerald-700 px-6 py-4 rounded-xl flex items-center gap-3">
                                    <svg class="w-6 h-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                    <p class="font-bold">{{ session('success') }}</p>
                                </div>
                            @endif

                            <form action="{{ route('contact.submit') }}" method="POST" class="space-y-6">
                                @csrf
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block text-sm font-bold text-slate-700 mb-2">الاسم بالكامل</label>
                                        <input type="text" name="name" required class="w-full h-12 px-4 rounded-xl border-slate-200 bg-slate-50 focus:border-red-500 focus:ring-red-500/20 transition-all font-medium" placeholder="الاسم هنا...">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-bold text-slate-700 mb-2">رقم الهاتف</label>
                                        <input type="tel" name="phone" required class="w-full h-12 px-4 rounded-xl border-slate-200 bg-slate-50 focus:border-red-500 focus:ring-red-500/20 transition-all font-medium text-left dir-ltr" placeholder="+20...">
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-2">البريد الإلكتروني</label>
                                    <input type="email" name="email" required class="w-full h-12 px-4 rounded-xl border-slate-200 bg-slate-50 focus:border-red-500 focus:ring-red-500/20 transition-all font-medium" placeholder="email@example.com">
                                </div>

                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-2">الموضوع</label>
                                    <select name="subject" class="w-full h-12 px-4 rounded-xl border-slate-200 bg-slate-50 focus:border-red-500 focus:ring-red-500/20 transition-all font-medium">
                                        <option value="استفسار عام">استفسار عام</option>
                                        <option value="المبيعات">المبيعات</option>
                                        <option value="خدمة ما بعد البيع">خدمة ما بعد البيع</option>
                                        <option value="شكوى">شكوى</option>
                                        <option value="أخرى">أخرى</option>
                                    </select>
                                </div>

                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-2">نص الرسالة</label>
                                    <textarea name="message" rows="5" required class="w-full p-4 rounded-xl border-slate-200 bg-slate-50 focus:border-red-500 focus:ring-red-500/20 transition-all font-medium resize-none" placeholder="اكتب رسالتك هنا بالتفصيل..."></textarea>
                                </div>

                                <button type="submit" class="w-full md:w-auto px-8 py-4 bg-red-600 hover:bg-red-700 text-white font-bold rounded-xl shadow-lg shadow-red-600/30 transition-all transform hover:-translate-y-1 flex items-center justify-center gap-2">
                                    <span>إرسال الرسالة</span>
                                    <svg class="w-5 h-5 rtl:rotate-180" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" /></svg>
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Map -->
                    <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 border border-slate-100 overflow-hidden h-80 relative group">
                        <iframe src="{{ $contactInfo->map_url ?? 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3455.578641328458!2d31.2089!3d30.0131!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzAsMDEzJzEsMzEsMjA4Jzk!5e0!3m2!1sen!2seg!4v1620000000000!5m2!1sen!2seg' }}" 
                                width="100%" height="100%" style="border:0; filter: grayscale(100%) contrast(1.2);" allowfullscreen="" loading="lazy"
                                class="transition-all duration-700 group-hover:filter-none"></iframe>
                        <div class="absolute inset-0 pointer-events-none border-[6px] border-white/50 rounded-3xl z-10"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-public-layout>
