<x-public-layout>
    <div x-data="{ activeTab: 'services' }">
        <!-- Header -->
        <div class="bg-gradient-to-r from-blue-900 to-blue-700 text-white">
            <div class="container mx-auto px-4 py-12">
                <div class="max-w-6xl mx-auto">
                    <a href="/" class="inline-flex items-center text-blue-200 hover:text-white mb-6 transition-colors">
                        <x-icon name="ArrowRight" class="ml-2 h-4 w-4" /> <!-- Laravel uses RTL logic? ArrowRight points left in RTL usually? Or should use ArrowRight for 'Back' in RTL? No, usually ArrowRight points to start of text in LTR. In RTL 'Back' is ArrowRight (pointing right). -->
                        العودة للرئيسية
                    </a>
                    <div class="text-center">
                        <h1 class="text-4xl md:text-5xl font-bold mb-6">
                            مركز الصيانة والإصلاح
                        </h1>
                        <p class="text-xl text-blue-100 mb-8">
                            خدمة احترافية لسيارتك تاتا مع فنيين معتمدين وقطع غيار أصلية
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="container mx-auto px-4 py-8">
            <div class="max-w-6xl mx-auto">
                <!-- Tabs Navigation -->
                <div class="w-full mb-8 border-b border-gray-200">
                    <div class="flex flex-wrap -mb-px">
                        <button @click="activeTab = 'services'" :class="{ 'border-blue-600 text-blue-600': activeTab === 'services', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'services' }" class="w-1/4 py-4 px-1 text-center border-b-2 font-medium text-sm flex items-center justify-center gap-2 transition-colors">
                            <x-icon name="Wrench" class="h-4 w-4" />
                            الخدمات
                        </button>
                        <button @click="activeTab = 'packages'" :class="{ 'border-blue-600 text-blue-600': activeTab === 'packages', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'packages' }" class="w-1/4 py-4 px-1 text-center border-b-2 font-medium text-sm flex items-center justify-center gap-2 transition-colors">
                            <x-icon name="Star" class="h-4 w-4" />
                            الباقات
                        </button>
                        <button @click="activeTab = 'technicians'" :class="{ 'border-blue-600 text-blue-600': activeTab === 'technicians', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'technicians' }" class="w-1/4 py-4 px-1 text-center border-b-2 font-medium text-sm flex items-center justify-center gap-2 transition-colors">
                            <x-icon name="Users" class="h-4 w-4" />
                            الفنيين
                        </button>
                        <button @click="activeTab = 'info'" :class="{ 'border-blue-600 text-blue-600': activeTab === 'info', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'info' }" class="w-1/4 py-4 px-1 text-center border-b-2 font-medium text-sm flex items-center justify-center gap-2 transition-colors">
                            <x-icon name="Settings" class="h-4 w-4" />
                            معلومات
                        </button>
                    </div>
                </div>

                <!-- Services Tab -->
                <div x-show="activeTab === 'services'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" class="space-y-6">
                    <div class="text-center mb-8">
                        <h2 class="text-3xl font-bold mb-4 text-gray-900">خدمات الصيانة والإصلاح</h2>
                        <p class="text-gray-600">
                            نقدم مجموعة شاملة من خدمات الصيانة والإصلاح لسيارات تاتا
                        </p>
                    </div>

                    <!-- Popular Services -->
                    <div class="mb-12">
                        <h3 class="text-2xl font-semibold mb-6 flex items-center gap-2 text-gray-900">
                            <x-icon name="Star" class="h-5 w-5 text-blue-600" />
                            الخدمات الأكثر طلباً
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            @foreach(collect($services)->where('popular', true) as $service)
                                <div class="bg-white rounded-xl shadow-md border-2 border-blue-100 hover:shadow-xl transition-all duration-300 overflow-hidden">
                                    <div class="p-6">
                                        <div class="flex items-center justify-between mb-4">
                                            <div class="flex items-center gap-3">
                                                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                                                    <x-icon :name="$service->icon" class="h-6 w-6 text-blue-600" />
                                                </div>
                                                <div>
                                                    <h3 class="text-lg font-bold text-gray-900">{{ $service->name }}</h3>
                                                    <p class="text-sm text-gray-500">{{ $service->category }}</p>
                                                </div>
                                            </div>
                                            <span class="bg-blue-600 text-white text-xs font-bold px-2 py-1 rounded">الأكثر طلباً</span>
                                        </div>
                                        
                                        <div class="space-y-4">
                                            <p class="text-gray-600 text-sm">{{ $service->description }}</p>
                                            <div class="flex justify-between items-center text-sm">
                                                <span class="flex items-center gap-1 text-gray-500">
                                                    <x-icon name="Clock" class="h-4 w-4" />
                                                    {{ $service->duration }}
                                                </span>
                                                <span class="font-bold text-blue-600">{{ $service->price }}</span>
                                            </div>
                                            <div>
                                                <h4 class="font-medium mb-2 text-sm text-gray-900">يشمل:</h4>
                                                <ul class="space-y-1">
                                                    @foreach(array_slice($service->features, 0, 3) as $feature)
                                                        <li class="flex items-center gap-2 text-sm text-gray-600">
                                                            <x-icon name="CheckCircle" class="h-3 w-3 text-green-500" />
                                                            {{ $feature }}
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                            <a href="{{ route('public.service-booking') }}" class="block w-full py-2 bg-blue-600 hover:bg-blue-700 text-white text-center rounded-lg transition-colors font-medium flex items-center justify-center gap-2">
                                                <x-icon name="Calendar" class="h-4 w-4" />
                                                احجز الآن
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- All Services -->
                    <div>
                        <h3 class="text-2xl font-semibold mb-6 text-gray-900">جميع الخدمات</h3>
                        <div class="space-y-10">
                            @foreach($groupedServices as $category => $categoryServices)
                                <div>
                                    <h4 class="text-xl font-semibold mb-4 text-gray-800 border-r-4 border-blue-600 pr-3">{{ $category }}</h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                        @foreach($categoryServices as $service)
                                            <div class="bg-white rounded-lg p-4 shadow-sm hover:shadow-md transition-shadow border border-gray-100">
                                                <div class="flex items-center gap-3 mb-3">
                                                    <div class="w-10 h-10 bg-blue-50 rounded-lg flex items-center justify-center shrink-0">
                                                        <x-icon :name="$service->icon" class="h-5 w-5 text-blue-600" />
                                                    </div>
                                                    <div>
                                                        <h5 class="text-base font-bold text-gray-900">{{ $service->name }}</h5>
                                                        <p class="text-xs text-gray-500">{{ $service->duration }}</p>
                                                    </div>
                                                </div>
                                                <div class="flex justify-between items-center mb-3">
                                                    <span class="font-bold text-blue-600 text-sm">{{ $service->price }}</span>
                                                </div>
                                                <a href="{{ route('public.service-booking') }}" class="block w-full py-1.5 px-3 bg-white border border-blue-200 text-blue-700 text-center rounded hover:bg-blue-50 transition-colors text-sm font-medium">
                                                    احجز
                                                </a>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <!-- Packages Tab -->
                <div x-show="activeTab === 'packages'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" class="space-y-8" style="display: none;">
                    <div class="text-center mb-8">
                        <h2 class="text-3xl font-bold mb-4 text-gray-900">باقات الصيانة</h2>
                        <p class="text-gray-600">
                            اختر الباقة المناسبة لسيارتك ووفر على خدمات الصيانة
                        </p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        @foreach($packages as $index => $pkg)
                            <div class="bg-white rounded-xl shadow-lg relative hover:shadow-xl transition-all duration-300 overflow-hidden {{ $index === 1 ? 'border-2 border-blue-500 ring-4 ring-blue-50 transform md:-translate-y-4' : 'border border-gray-100' }}">
                                @if($index === 1)
                                    <div class="absolute top-0 inset-x-0 h-1 bg-blue-500"></div>
                                    <div class="absolute -top-3 left-1/2 transform -translate-x-1/2">
                                        <span class="bg-blue-500 text-white text-xs font-bold px-3 py-1 rounded-full uppercase tracking-wide">الأكثر مبيعاً</span>
                                    </div>
                                @endif
                                
                                <div class="p-6 text-center border-b border-gray-100">
                                    <h3 class="text-xl font-bold text-gray-900 mb-2">{{ $pkg->name }}</h3>
                                    <p class="text-gray-500 text-sm mb-4">{{ $pkg->description }}</p>
                                    <div class="flex flex-col items-center">
                                        <span class="text-3xl font-bold text-blue-600">{{ $pkg->price }}</span>
                                        <span class="text-sm text-green-600 font-medium bg-green-50 px-2 py-0.5 rounded-full mt-2">{{ $pkg->savings }}</span>
                                    </div>
                                </div>
                                <div class="p-6 space-y-6">
                                    <div>
                                        <h4 class="font-medium mb-3 text-sm text-gray-900">الخدمات المشمولة:</h4>
                                        <ul class="space-y-2">
                                            @foreach($pkg->services as $service)
                                                <li class="flex items-center gap-2 text-sm text-gray-600">
                                                    <x-icon name="CheckCircle" class="h-4 w-4 text-green-500 shrink-0" />
                                                    {{ $service }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    <div>
                                        <h4 class="font-medium mb-3 text-sm text-gray-900">يشمل أيضاً:</h4>
                                        <ul class="space-y-2">
                                            @foreach($pkg->includes as $item)
                                                <li class="flex items-center gap-2 text-sm text-gray-600">
                                                    <x-icon name="CheckCircle" class="h-4 w-4 text-blue-500 shrink-0" />
                                                    {{ $item }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    <div class="text-center pt-2">
                                        <span class="inline-block px-3 py-1 bg-gray-100 text-gray-600 text-xs font-semibold rounded-full border border-gray-200">الصلاحية: {{ $pkg->validity }}</span>
                                    </div>
                                    <a href="{{ route('public.service-booking') }}" class="block w-full py-3 {{ $index === 1 ? 'bg-blue-600 hover:bg-blue-700 text-white' : 'bg-white border border-blue-600 text-blue-600 hover:bg-blue-50' }} text-center rounded-lg transition-colors font-bold">
                                        اشترك الآن
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Technicians Tab -->
                <div x-show="activeTab === 'technicians'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" class="space-y-8" style="display: none;">
                    <div class="text-center mb-8">
                        <h2 class="text-3xl font-bold mb-4 text-gray-900">فريق الفنيين</h2>
                        <p class="text-gray-600">
                            فريق من الفنيين المعتمدين والخبراء في صيانة سيارات تاتا
                        </p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        @foreach($technicians as $technician)
                            <div class="bg-white rounded-xl shadow-md p-6 border border-gray-100 hover:shadow-lg transition-shadow">
                                <div class="flex items-start gap-4">
                                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                                        <x-icon name="Users" class="h-8 w-8 text-blue-600" />
                                    </div>
                                    <div class="flex-1">
                                        <div class="flex justify-between items-start mb-2">
                                            <div>
                                                <h3 class="text-xl font-bold text-gray-900">{{ $technician->name }}</h3>
                                                <p class="text-gray-600 text-sm">{{ $technician->specialty }}</p>
                                            </div>
                                            <div class="flex items-center gap-1 bg-yellow-50 px-2 py-1 rounded">
                                                <x-icon name="Star" class="h-4 w-4 text-yellow-500" />
                                                <span class="font-bold text-gray-800">{{ $technician->rating }}</span>
                                            </div>
                                        </div>
                                        <p class="text-sm text-gray-600 mb-3">الخبرة: <span class="font-semibold">{{ $technician->experience }}</span></p>
                                        <div>
                                            <h4 class="font-medium mb-2 text-sm text-gray-900">الشهادات:</h4>
                                            <div class="flex flex-wrap gap-2">
                                                @foreach($technician->certifications as $cert)
                                                    <span class="px-2 py-1 bg-gray-100 text-gray-600 text-xs rounded border border-gray-200">
                                                        {{ $cert }}
                                                    </span>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Info Tab -->
                <div x-show="activeTab === 'info'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" class="space-y-8" style="display: none;">
                    <div class="text-center mb-8">
                        <h2 class="text-3xl font-bold mb-4 text-gray-900">معلومات مركز الصيانة</h2>
                        <p class="text-gray-600">
                            كل ما تحتاج معرفته عن خدمات الصيانة لدينا
                        </p>
                    </div>

                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                        <!-- Working Hours -->
                        <div class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden">
                            <div class="p-6 border-b border-gray-100 bg-gray-50">
                                <h3 class="text-lg font-bold flex items-center gap-2 text-gray-900">
                                    <x-icon name="Clock" class="h-5 w-5 text-blue-600" />
                                    ساعات العمل
                                </h3>
                            </div>
                            <div class="p-6 space-y-4">
                                <div class="flex justify-between items-center border-b border-gray-50 pb-2">
                                    <span class="text-gray-600">السبت - الخميس</span>
                                    <span class="font-bold text-gray-800 dir-ltr">8:00 ص - 8:00 م</span>
                                </div>
                                <div class="flex justify-between items-center border-b border-gray-50 pb-2">
                                    <span class="text-gray-600">الجمعة</span>
                                    <span class="font-bold text-gray-800 dir-ltr">2:00 م - 8:00 م</span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-600">خدمة الطوارئ</span>
                                    <span class="font-bold text-red-600 dir-ltr">24/7</span>
                                </div>
                                <div class="mt-4 p-4 bg-yellow-50 border border-yellow-100 rounded-lg flex items-start gap-3">
                                    <x-icon name="AlertTriangle" class="h-5 w-5 text-yellow-600 shrink-0 mt-0.5" />
                                    <p class="text-sm text-yellow-800">
                                        يفضل حجز المواعيد مسبقاً لتجنب الانتظار، خاصة في أيام العطلات.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Contact Info -->
                        <div class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden">
                            <div class="p-6 border-b border-gray-100 bg-gray-50">
                                <h3 class="text-lg font-bold flex items-center gap-2 text-gray-900">
                                    <x-icon name="Phone" class="h-5 w-5 text-blue-600" />
                                    معلومات الاتصال
                                </h3>
                            </div>
                            <div class="p-6 space-y-6">
                                <div class="flex items-center gap-4">
                                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center shrink-0">
                                        <x-icon name="Phone" class="h-5 w-5 text-gray-500" />
                                    </div>
                                    <div>
                                        <p class="font-bold text-gray-900">خدمة العملاء</p>
                                        <p class="text-gray-600 dir-ltr text-right">+20 155 576 7729</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div class="w-10 h-10 bg-red-100 rounded-full flex items-center justify-center shrink-0">
                                        <x-icon name="AlertTriangle" class="h-5 w-5 text-red-500" />
                                    </div>
                                    <div>
                                        <p class="font-bold text-gray-900">الطوارئ</p>
                                        <p class="text-gray-600 dir-ltr text-right">+20 123 456 7890</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center shrink-0">
                                        <x-icon name="Mail" class="h-5 w-5 text-gray-500" />
                                    </div>
                                    <div>
                                        <p class="font-bold text-gray-900">البريد الإلكتروني</p>
                                        <p class="text-gray-600">info@elhamdimport.online</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-public-layout>
