<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                {{-- Header --}}
                <div class="text-center mb-12">
                    <div class="flex justify-center mb-4">
                        <div class="p-4 bg-blue-100 rounded-full">
                            <x-icon name="Package" class="h-10 w-10 text-blue-600" />
                        </div>
                    </div>
                    <h1 class="text-4xl font-bold text-gray-900 mb-4">قطع الغيار الأصلية</h1>
                    <p class="text-xl text-gray-600">
                        نوفر جميع قطع الغيار الأصلية لسياراتكم المستوردة مع ضمان الجودة
                    </p>
                </div>

                {{-- Parts Categories --}}
                <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
                    {{-- Engine Parts --}}
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <x-icon name="Wrench" class="h-6 w-6 text-blue-600" />
                            <h3 class="font-bold text-lg">قطع غيار المحرك</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">جميع قطع غيار المحرك الأصلية</p>
                        <ul class="space-y-2">
                            @foreach(['فلاتر الزيت والهواء', 'شمعات الإشعال', 'أحزمة التوقيت', 'مضخات الماء والزيت', 'رؤوس الأسطوانات'] as $item)
                                <li class="flex items-center gap-2 text-sm text-gray-700">
                                    <x-icon name="Check" class="h-4 w-4 text-green-600" />
                                    <span>{{ $item }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    {{-- Brake System --}}
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <x-icon name="Shield" class="h-6 w-6 text-blue-600" />
                            <h3 class="font-bold text-lg">نظام الفرامل</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">قطع نظام الفرامل عالية الجودة</p>
                        <ul class="space-y-2">
                            @foreach(['تيل الفرامل', 'أسطوانات الفرامل', 'سوائل الفرامل', 'أقراص الفرامل', 'مضخات الفرامل'] as $item)
                                <li class="flex items-center gap-2 text-sm text-gray-700">
                                    <x-icon name="Check" class="h-4 w-4 text-green-600" />
                                    <span>{{ $item }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    {{-- Tires & Wheels --}}
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <x-icon name="Package" class="h-6 w-6 text-blue-600" />
                            <h3 class="font-bold text-lg">الإطارات والعجلات</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">إطارات وعجلات من أفضل الشركات</p>
                        <ul class="space-y-2">
                            @foreach(['إطارات صيفية وشتوية', 'عجلات ألومنيوم', 'براغي وصواميل العجلات', 'موازنات العجلات', 'غطاء العجلات'] as $item)
                                <li class="flex items-center gap-2 text-sm text-gray-700">
                                    <x-icon name="Check" class="h-4 w-4 text-green-600" />
                                    <span>{{ $item }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    {{-- Electronics --}}
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <x-icon name="Check" class="h-6 w-6 text-blue-600" />
                            <h3 class="font-bold text-lg">الإلكترونيات</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">قطع إلكترونية وكهربائية</p>
                        <ul class="space-y-2">
                            @foreach(['بطاريات السيارات', 'مولدات الكهرباء', 'أنظمة الصوت', 'كاميرات الرجوع', 'أجهزة الاستشعار'] as $item)
                                <li class="flex items-center gap-2 text-sm text-gray-700">
                                    <x-icon name="Check" class="h-4 w-4 text-green-600" />
                                    <span>{{ $item }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>

                {{-- Services --}}
                <div class="grid md:grid-cols-3 gap-8 mb-12">
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100 text-center">
                        <div class="flex justify-center mb-4">
                            <div class="p-3 bg-blue-50 rounded-full">
                                {{-- Truck icon approximation with generic Icon or specific SVG if needed. Using 'Car' as generic vehicle for now --}}
                                <x-icon name="Car" class="h-8 w-8 text-blue-600" /> 
                            </div>
                        </div>
                        <h3 class="font-bold text-lg mb-2">توصيل سريع</h3>
                        <p class="text-gray-600">توصيل قطع الغيار خلال 24-48 ساعة</p>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100 text-center">
                        <div class="flex justify-center mb-4">
                            <div class="p-3 bg-blue-50 rounded-full">
                                <x-icon name="Shield" class="h-8 w-8 text-blue-600" />
                            </div>
                        </div>
                        <h3 class="font-bold text-lg mb-2">ضمان الجودة</h3>
                        <p class="text-gray-600">جميع القطع أصلية ومعتمدة من المصنع</p>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100 text-center">
                        <div class="flex justify-center mb-4">
                            <div class="p-3 bg-blue-50 rounded-full">
                                <x-icon name="Wrench" class="h-8 w-8 text-blue-600" />
                            </div>
                        </div>
                        <h3 class="font-bold text-lg mb-2">خدمة 24/7</h3>
                        <p class="text-gray-600">دعم فني على مدار الساعة</p>
                    </div>
                </div>

                {{-- Why Choose Us --}}
                <div class="bg-white rounded-lg shadow-sm p-8 mb-8 border border-gray-100">
                    <h2 class="text-2xl font-bold mb-6 border-b pb-4">لماذا تختار قطع الغيار منا؟</h2>
                    <div class="grid md:grid-cols-2 gap-8">
                        <div>
                            <h3 class="font-semibold mb-4 text-lg">المميزات:</h3>
                            <ul class="space-y-3">
                                @foreach(['قطع أصلية 100% من المصنع', 'ضمان على جميع القطع', 'أسعار تنافسية', 'توصيل سريع لجميع المحافظات'] as $feat)
                                    <li class="flex items-center gap-3">
                                        <x-icon name="Check" class="h-5 w-5 text-green-600" />
                                        <span>{{ $feat }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div>
                            <h3 class="font-semibold mb-4 text-lg">الخدمات الإضافية:</h3>
                            <ul class="space-y-3">
                                @foreach(['تركيب مجاني للقطع', 'استشارة فنية مجانية', 'تتبع الطلبات عبر الإنترنت', 'دعم فني 24/7'] as $feat)
                                    <li class="flex items-center gap-3">
                                        <x-icon name="Check" class="h-5 w-5 text-green-600" />
                                        <span>{{ $feat }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>

                {{-- CTA --}}
                <div class="bg-blue-50 rounded-2xl p-8 text-center border border-blue-100">
                    <h3 class="text-2xl font-bold text-blue-900 mb-4">هل تبحث عن قطعة غيار معينة؟</h3>
                    <p class="text-blue-700 mb-6 max-w-2xl mx-auto">
                        تواصل معنا وسنجد لك القطعة الأصلية بأفضل سعر
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <a href="tel:+201555767729" class="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700 transition-colors font-semibold shadow-sm hover:shadow-md">
                            اطلب الآن
                        </a>
                        <a href="{{ route('contact') }}" class="bg-white border-2 border-blue-600 text-blue-600 px-8 py-3 rounded-lg hover:bg-blue-50 transition-colors font-semibold">
                            استفسار عن قطعة
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-public-layout>
