<x-public-layout>
    <div class="min-h-screen bg-slate-50 pb-20" x-data="serviceBooking()">
        <!-- Page Header -->
        <div class="relative bg-slate-900 text-white overflow-hidden mb-8">
            <div class="absolute inset-0 bg-[url('/grid-pattern.svg')] opacity-10"></div>
            <div class="absolute inset-0 bg-gradient-to-br from-blue-900/90 via-slate-900/95 to-slate-900/90"></div>
            <div class="container relative mx-auto px-4 py-16 md:py-20">
                <div class="max-w-3xl">
                    <span class="inline-block px-3 py-1 rounded-full text-xs font-semibold bg-blue-500/20 text-blue-200 border border-blue-500/50 mb-4 backdrop-blur-sm">
                        نظام الحجز الإلكتروني
                    </span>
                    <h1 class="text-4xl md:text-5xl font-bold mb-6 tracking-tight">حجز موعد صيانة</h1>
                    <p class="text-lg text-blue-100/80 leading-relaxed max-w-2xl">
                        احجز موعد صيانتك القادم بكل سهولة. اختر نوع الخدمة، الموعد المناسب، ودع فريقنا المتخصص يهتم بسيارتك.
                    </p>
                </div>
            </div>
        </div>

        <div class="container mx-auto px-4">
            <div class="max-w-5xl mx-auto">
                <!-- Progress Steps -->
                <div x-show="!submitSuccess" class="mb-10 overflow-x-auto">
                    <div class="flex items-center justify-between min-w-[600px] bg-white p-4 rounded-xl shadow-sm border border-gray-100">
                        <template x-for="stepNumber in [1, 2, 3, 4, 5]" :key="stepNumber">
                            <div class="flex flex-col items-center relative z-10">
                                <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold transition-all duration-300"
                                     :class="step >= stepNumber ? 'bg-blue-600 text-white shadow-lg shadow-blue-600/30 scale-110' : 'bg-gray-100 text-gray-400 border border-gray-200'">
                                    <template x-if="step > stepNumber">
                                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                    </template>
                                    <template x-if="step <= stepNumber">
                                        <span x-text="stepNumber"></span>
                                    </template>
                                </div>
                                <span class="mt-2 text-xs font-semibold uppercase tracking-wider"
                                      :class="step >= stepNumber ? 'text-blue-700' : 'text-gray-400'">
                                    <span x-show="stepNumber === 1">المركبة</span>
                                    <span x-show="stepNumber === 2">الخدمة</span>
                                    <span x-show="stepNumber === 3">الموعد</span>
                                    <span x-show="stepNumber === 4">البيانات</span>
                                    <span x-show="stepNumber === 5">التأكيد</span>
                                </span>
                            </div>
                        </template>
                    </div>
                </div>

                <div class="transition-all duration-500 ease-in-out">
                    <!-- Success Message -->
                    <div x-show="submitSuccess" style="display: none;">
                         <div class="bg-white rounded-xl shadow-2xl overflow-hidden border-none text-center">
                            <div class="bg-green-500 h-2 w-full"></div>
                            <div class="p-16">
                                <div class="w-24 h-24 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6 shadow-xl shadow-green-100">
                                    <svg class="h-12 w-12 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                </div>
                                <h2 class="text-3xl font-bold mb-4 text-gray-900">تم حجز الموعد بنجاح!</h2>
                                <p class="text-gray-600 mb-8 max-w-lg mx-auto text-lg">
                                    شكراً لاختيارك مركز الحمد للصيانة. لقد تم تأكيد حجزك، وسيتم التواصل معك قريباً.
                                </p>
                                <div class="flex justify-center gap-4">
                                    <button @click="resetForm()" class="px-6 py-3 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 font-medium">حجز موعد جديد</button>
                                    <a href="/" class="px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-medium">العودة للرئيسية</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Step 1: Vehicle Selection -->
                    <div x-show="step === 1 && !submitSuccess">
                        <div class="space-y-6">
                             <div class="flex items-center justify-between">
                                <h2 class="text-2xl font-bold text-gray-900">اختر المركبة</h2>
                                <button @click="skipVehicleSelection()" class="text-blue-600 hover:text-blue-800 font-medium flex items-center">
                                    تخطي اختيار المركبة <svg class="mr-2 h-4 w-4 transform rotate-180" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" /></svg>
                                </button>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                @foreach($vehicles as $vehicle)
                                    <div @click="selectVehicle({{ $vehicle }})" 
                                         class="cursor-pointer bg-white p-6 rounded-xl shadow-sm border-2 transition-all duration-300 hover:shadow-xl group"
                                         :class="formData.vehicleId == '{{ $vehicle->id }}' ? 'border-blue-500 shadow-md bg-blue-50/10' : 'border-transparent hover:border-blue-200'">
                                        <div class="flex items-start justify-between mb-4">
                                            <div class="p-3 bg-blue-100/50 rounded-xl group-hover:bg-blue-100 transition-colors">
                                                <svg class="h-8 w-8 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4" /></svg>
                                            </div>
                                            <span x-show="formData.vehicleId == '{{ $vehicle->id }}'" class="bg-blue-600 text-white text-xs px-2 py-1 rounded">تم الاختيار</span>
                                        </div>
                                        <h3 class="text-xl font-bold text-gray-900 mb-1">{{ $vehicle->make }} {{ $vehicle->model }}</h3>
                                        <p class="text-sm text-gray-500 mb-4">{{ $vehicle->year }}</p>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <!-- Step 2: Service Selection -->
                    <div x-show="step === 2 && !submitSuccess" style="display: none;">
                        <div class="space-y-6">
                            <div class="flex items-center gap-4 mb-6">
                                <button @click="step = 1" class="p-2 border rounded-lg hover:bg-gray-50 text-gray-600">
                                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                                </button>
                                <h2 class="text-2xl font-bold text-gray-900">نوع الخدمة المطلوبة</h2>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                @foreach($serviceTypes as $service)
                                    <div @click="selectService('{{ $service->id }}', '{{ $service->name }}', {{ $service->price ?? 0 }})"
                                         class="cursor-pointer bg-white p-6 rounded-xl shadow-sm border-2 transition-all duration-200 hover:shadow-md"
                                         :class="formData.serviceTypeId == '{{ $service->id }}' ? 'border-blue-600 shadow-lg bg-blue-50/20' : 'border-transparent hover:border-blue-200'">
                                        <div class="flex items-start gap-4">
                                            <div class="flex-shrink-0 mt-1">
                                                <div class="w-5 h-5 rounded-full border border-gray-300 flex items-center justify-center cursor-pointer"
                                                     :class="formData.serviceTypeId == '{{ $service->id }}' ? 'bg-blue-600 border-blue-600' : ''">
                                                    <svg x-show="formData.serviceTypeId == '{{ $service->id }}'" class="w-3 h-3 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                                </div>
                                            </div>
                                            <div class="flex-1">
                                                <div class="flex justify-between items-start">
                                                    <h4 class="text-lg font-bold text-gray-900 mb-2">{{ $service->name }}</h4>
                                                    @if($service->price)
                                                        <span class="bg-blue-100 text-blue-700 text-xs font-bold px-2 py-1 rounded">{{ number_format($service->price) }} ج.م</span>
                                                    @endif
                                                </div>
                                                <p class="text-gray-600 text-sm mb-4 leading-relaxed">{{ $service->description }}</p>
                                                <div class="flex items-center gap-2 text-xs font-medium text-gray-500 bg-gray-100 w-fit px-2 py-1 rounded">
                                                    <svg class="h-3.5 w-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                                    <span>المدة التقديرية: {{ $service->duration }} دقيقة</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <!-- Step 3: Date & Time -->
                    <div x-show="step === 3 && !submitSuccess" style="display: none;">
                        <div class="space-y-6">
                            <div class="flex items-center gap-4 mb-6">
                                <button @click="step = 2" class="p-2 border rounded-lg hover:bg-gray-50 text-gray-600">
                                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                                </button>
                                <h2 class="text-2xl font-bold text-gray-900">تحديد الموعد</h2>
                            </div>
                            
                            <div class="bg-white rounded-xl shadow-sm border p-6">
                                <!-- Simple Date Input for MVP -->
                                <label class="block text-sm font-medium text-gray-700 mb-2">اختر التاريخ</label>
                                <input type="date" x-model="formData.date" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm mb-4">
                                
                                <label class="block text-sm font-medium text-gray-700 mb-2">اختر الوقت</label>
                                <select x-model="formData.timeSlot" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm" @change="if(formData.date && formData.timeSlot) step = 4">
                                    <option value="">اختر الوقت</option>
                                    <option value="09:00">09:00 ص</option>
                                    <option value="10:00">10:00 ص</option>
                                    <option value="11:00">11:00 ص</option>
                                    <option value="12:00">12:00 م</option>
                                    <option value="13:00">01:00 م</option>
                                    <option value="14:00">02:00 م</option>
                                    <option value="15:00">03:00 م</option>
                                    <option value="16:00">04:00 م</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Step 4: Customer Details -->
                    <div x-show="step === 4 && !submitSuccess" style="display: none;">
                         <div class="space-y-6">
                            <div class="flex items-center gap-4 mb-6">
                                <button @click="step = 3" class="p-2 border rounded-lg hover:bg-gray-50 text-gray-600">
                                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                                </button>
                                <h2 class="text-2xl font-bold text-gray-900">مراجعة البيانات وتأكيد الحجز</h2>
                            </div>

                            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                                <div class="lg:col-span-2 space-y-6">
                                    <div class="bg-white rounded-xl shadow-sm border p-6">
                                        <h3 class="font-bold text-lg mb-4">بيانات التواصل</h3>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700">الاسم الكامل *</label>
                                                <input type="text" x-model="formData.customerInfo.name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm bg-gray-50">
                                            </div>
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700">رقم الهاتف *</label>
                                                <input type="tel" x-model="formData.customerInfo.phone" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm bg-gray-50">
                                            </div>
                                            <div class="md:col-span-2">
                                                <label class="block text-sm font-medium text-gray-700">البريد الإلكتروني *</label>
                                                <input type="email" x-model="formData.customerInfo.email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm bg-gray-50">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="bg-white rounded-xl shadow-sm border p-6">
                                        <h3 class="font-bold text-lg mb-4">معلومات إضافية</h3>
                                        <div class="space-y-4">
                                             <div>
                                                <label class="block text-sm font-medium text-gray-700">ملاحظات لفريق الصيانة</label>
                                                <textarea x-model="formData.notes" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm bg-gray-50"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="lg:col-span-1">
                                    <div class="bg-white rounded-xl shadow-lg border border-blue-100 overflow-hidden sticky top-4">
                                        <div class="bg-blue-600 px-6 py-4">
                                            <h3 class="font-bold text-white text-lg">تفاصيل الحجز</h3>
                                        </div>
                                        <div class="p-6 space-y-4">
                                            <div class="flex justify-between items-center border-b pb-3 border-gray-100">
                                                <span class="text-gray-500">المركبة</span>
                                                <span class="font-semibold text-gray-900" x-text="selectedVehicleName || 'غير محدد'"></span>
                                            </div>
                                            <div class="flex justify-between items-center border-b pb-3 border-gray-100">
                                                <span class="text-gray-500">الخدمة</span>
                                                <span class="font-semibold text-gray-900" x-text="selectedServiceName || 'غير محدد'"></span>
                                            </div>
                                            <div class="flex justify-between items-center border-b pb-3 border-gray-100">
                                                <span class="text-gray-500">التاريخ</span>
                                                <span class="font-semibold text-gray-900" x-text="formData.date"></span>
                                            </div>
                                            <div class="flex justify-between items-center border-b pb-3 border-gray-100">
                                                <span class="text-gray-500">الوقت</span>
                                                <span class="font-semibold text-gray-900" x-text="formData.timeSlot"></span>
                                            </div>
                                            <div class="flex justify-between items-center pt-2">
                                                <span class="text-lg font-bold text-gray-900">الإجمالي</span>
                                                <span class="text-xl font-bold text-blue-600" x-text="selectedServicePrice + ' ج.م'"></span>
                                            </div>

                                            <button @click="submitForm()" 
                                                    class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-4 rounded-lg shadow-lg shadow-blue-600/20 mt-4 disabled:opacity-50 disabled:cursor-not-allowed"
                                                    :disabled="loading">
                                                <span x-show="!loading">تأكيد وحجز الموعد</span>
                                                <span x-show="loading">جاري المعالجة...</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script>
        function serviceBooking() {
            return {
                step: 1,
                loading: false,
                submitSuccess: false,
                selectedVehicleName: '',
                selectedServiceName: '',
                selectedServicePrice: 0,
                formData: {
                    vehicleId: '',
                    serviceTypeId: '',
                    date: '',
                    timeSlot: '',
                    customerInfo: {
                        name: '{{ Auth::user()->name ?? "" }}',
                        email: '{{ Auth::user()->email ?? "" }}',
                        phone: '{{ Auth::user()->phone ?? "" }}'
                    },
                    notes: ''
                },
                
                selectVehicle(vehicle) {
                    this.formData.vehicleId = vehicle.id;
                    this.selectedVehicleName = vehicle.make + ' ' + vehicle.model;
                    this.step = 2;
                },

                skipVehicleSelection() {
                    this.formData.vehicleId = '';
                    this.selectedVehicleName = 'غير محدد';
                    this.step = 2;
                },

                selectService(id, name, price) {
                    this.formData.serviceTypeId = id;
                    this.selectedServiceName = name;
                    this.selectedServicePrice = price;
                    this.step = 3;
                },

                submitForm() {
                    this.loading = true;
                    // Simulate API call
                    setTimeout(() => {
                        this.loading = false;
                        this.submitSuccess = true;
                        this.step = 5;
                    }, 1500);
                    
                    // Real implementation would be:
                    /*
                    fetch('/api/bookings/service', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify(this.formData)
                    })
                    .then(response => {
                        if (response.ok) {
                            this.submitSuccess = true;
                            this.step = 5;
                        } else {
                            alert('حدث خطأ أثناء الحجز');
                        }
                    })
                    .finally(() => {
                        this.loading = false;
                    });
                    */
                },

                resetForm() {
                    this.step = 1;
                    this.submitSuccess = false;
                    this.formData.vehicleId = '';
                    this.formData.serviceTypeId = '';
                    this.formData.date = '';
                    this.formData.timeSlot = '';
                    this.formData.notes = '';
                    this.selectedVehicleName = '';
                    this.selectedServiceName = '';
                    this.selectedServicePrice = 0;
                }
            }
        }
    </script>
</x-public-layout>
