<x-public-layout>
    <!-- Header -->
    <div class="bg-gradient-to-r from-blue-900 to-blue-700 text-white">
        <div class="container mx-auto px-4 py-16">
            <div class="text-center">
                <h1 class="text-4xl md:text-5xl font-bold mb-4">{{ $serviceCopy->title }}</h1>
                <p class="text-xl text-blue-100 max-w-3xl mx-auto">{{ $serviceCopy->subtitle }}</p>
                @if($serviceCopy->description)
                    <p class="mt-4 text-blue-100/90 max-w-4xl mx-auto text-lg">{{ $serviceCopy->description }}</p>
                @endif
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 py-12">
        <!-- Services Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
            @foreach($services as $service)
                <div class="bg-white rounded-xl shadow-md hover:shadow-xl transition-shadow duration-300 border border-gray-100 overflow-hidden">
                    <div class="p-6">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center shrink-0">
                                <x-icon :name="$service->icon" class="h-8 w-8 text-blue-600" />
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900">{{ $service->title }}</h3>
                                <p class="text-sm text-gray-500">{{ $service->description }}</p>
                            </div>
                        </div>

                        <div class="space-y-4 pt-4 border-t border-gray-100">
                            <div>
                                <h4 class="font-semibold mb-2 text-sm text-gray-700">المميزات:</h4>
                                <ul class="space-y-1">
                                    @foreach($service->features as $feature)
                                        <li class="flex items-center gap-2 text-sm text-gray-600">
                                            <x-icon name="CheckCircle" class="h-4 w-4 text-green-500" />
                                            {{ $feature }}
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                            
                            @if(isset($service->price))
                                <div class="flex justify-between items-center">
                                    <span class="text-sm text-gray-500">السعر:</span>
                                    <span class="px-2 py-1 bg-gray-100 rounded text-sm font-medium text-gray-800">{{ $service->price }}</span>
                                </div>
                            @endif
                            
                            @if(isset($service->duration))
                                <div class="flex justify-between items-center">
                                    <span class="text-sm text-gray-500">المدة:</span>
                                    <span class="text-sm font-medium text-gray-900 dir-ltr">{{ $service->duration }}</span>
                                </div>
                            @endif

                            <a href="{{ route('public.service-booking') }}" class="block w-full mt-4 py-2 px-4 bg-blue-600 text-white text-center rounded-lg hover:bg-blue-700 transition-colors flex items-center justify-center gap-2">
                                {{ $serviceCopy->ctaText }}
                                <x-icon name="ArrowLeft" class="h-4 w-4" />
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- CTA Section -->
        <div class="bg-blue-600 rounded-2xl p-8 text-center text-white mb-16">
            <h2 class="text-3xl font-bold mb-4">هل تحتاج إلى مساعدة؟</h2>
            <p class="text-xl mb-8 text-blue-100">
                فريقنا من الخبراء جاهز لمساعدتك في أي وقت
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="{{ route('contact') }}" class="inline-flex items-center justify-center px-6 py-3 bg-white text-blue-900 rounded-lg hover:bg-gray-100 transition-colors font-semibold gap-2">
                    <x-icon name="Phone" class="h-5 w-5" />
                    اتصل بنا
                </a>
                <a href="{{ route('public.service-booking') }}" class="inline-flex items-center justify-center px-6 py-3 bg-blue-700 text-white rounded-lg hover:bg-blue-800 transition-colors font-semibold gap-2 border border-blue-500">
                    <x-icon name="Clock" class="h-5 w-5" />
                    احجز موعد
                </a>
            </div>
        </div>

        <!-- Why Choose Us -->
        <div class="mt-16">
            <h2 class="text-3xl font-bold text-center mb-12">لماذا تختارنا؟</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="text-center p-6 bg-white rounded-xl shadow-sm border border-gray-100">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <x-icon name="Users" class="h-8 w-8 text-blue-600" />
                    </div>
                    <h3 class="text-xl font-semibold mb-2">فريق محترف</h3>
                    <p class="text-gray-600">فنيون مدربون وذوو خبرة في جميع أنواع السيارات</p>
                </div>
                <div class="text-center p-6 bg-white rounded-xl shadow-sm border border-gray-100">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <x-icon name="Shield" class="h-8 w-8 text-green-600" />
                    </div>
                    <h3 class="text-xl font-semibold mb-2">ضمان الجودة</h3>
                    <p class="text-gray-600">نضمن جودة الخدمة واستخدام قطع غيار أصلية</p>
                </div>
                <div class="text-center p-6 bg-white rounded-xl shadow-sm border border-gray-100">
                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <x-icon name="Clock" class="h-8 w-8 text-purple-600" />
                    </div>
                    <h3 class="text-xl font-semibold mb-2">خدمة سريعة</h3>
                    <p class="text-gray-600">نقدم خدمات سريعة وفعالة دون التضحية بالجودة</p>
                </div>
            </div>
        </div>
    </div>
</x-public-layout>
