<x-public-layout>
    <div class="min-h-screen bg-gray-50 py-12">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                {{-- Header --}}
                <div class="text-center mb-12">
                    <div class="flex justify-center mb-4">
                        <div class="p-4 bg-blue-100 rounded-full">
                            {{-- Headphones icon --}}
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 text-blue-600">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M10.343 3.94c.09-.542.56-.94 1.11-.94h1.093c.55 0 1.02.398 1.11.94l.149.894c.07.424.384.764.78.93.398.164.855.142 1.205-.108l.737-.527a1.125 1.125 0 011.45.12l.773.774c.39.389.44 1.002.12 1.45l-.527.737c-.25.35-.272.806-.107 1.204.165.397.505.71.93.78l.893.15c.543.09.94.56.94 1.109v1.094c0 .55-.397 1.02-.94 1.11l-.893.149c-.425.07-.765.383-.93.78-.165.398-.143.854.107 1.204l.527.738c.32.447.27.106-.12 1.45l-.774.773a1.125 1.125 0 01-1.449.12l-.738-.527c-.35-.25-.806-.272-1.203-.107-.397.165-.71.505-.781.929l-.149.894c-.09.542-.56.94-1.11.94h-1.094c-.55 0-1.019-.398-1.11-.94l-.148-.894c-.071-.424-.384-.764-.781-.93-.398-.164-.854-.142-1.204.108l-.738.527c-.447.32-1.06.269-1.45-.12l-.773-.774a1.125 1.125 0 01-.12-1.45l.527-.737c.25-.35.273-.806.108-1.204-.165-.397-.506-.71-.93-.78l-.894-.15c-.542-.09-.94-.56-.94-1.109v-1.094c0-.55.398-1.02.94-1.11l.894-.149c.424-.07.765-.383.93-.78.165-.398.143-.854-.107-1.204l-.527-.738a1.125 1.125 0 01.12-1.45l.773-.773a1.125 1.125 0 011.45-.12l.737.527c.35.25.807.272 1.204.107.397-.165.71-.505.78-.929l.15-.894z" />
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                            </svg>
                        </div>
                    </div>
                    <h1 class="text-4xl font-bold text-gray-900 mb-4">الدعم الفني</h1>
                    <p class="text-xl text-gray-600">
                        فريق الدعم الفني المتخصص جاهز لمساعدتك في أي وقت
                    </p>
                </div>

                {{-- Support Channels --}}
                <div class="grid md:grid-cols-3 gap-8 mb-12">
                    {{-- Phone --}}
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-2">
                             {{-- Phone icon --}}
                            <div class="p-2 bg-blue-50 rounded-lg">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 text-blue-600">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 6.75c0 8.284 6.716 15 15 15h2.25a2.25 2.25 0 002.25-2.25v-1.372c0-.516-.351-.966-.852-1.091l-4.423-1.106c-.44-.11-.902.055-1.173.417l-.97 1.293c-.282.376-.769.542-1.21.38a12.035 12.035 0 01-7.143-7.143c-.162-.441.004-.928.38-1.21l1.293-.97c.363-.271.527-.734.417-1.173L6.963 3.102a1.125 1.125 0 00-1.091-.852H4.5A2.25 2.25 0 002.25 4.5v2.25z" />
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg">الدعم عبر الهاتف</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">دعم فني مباشر على مدار الساعة</p>
                        <div class="space-y-4">
                            <div>
                                <p class="text-sm text-gray-600">التواصل:</p>
                                <p class="font-semibold text-gray-900" dir="ltr">+20 155 576 7729</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">ساعات العمل:</p>
                                <p class="font-semibold text-gray-900">24/7</p>
                            </div>
                            <a href="tel:+201555767729" class="block w-full bg-blue-600 text-white text-center py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium">
                                اتصل الآن
                            </a>
                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-2">
                            {{-- Mail icon --}}
                            <div class="p-2 bg-blue-50 rounded-lg">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 text-blue-600">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75" />
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg">الدعم عبر البريد</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">إرسال استفساراتكم التقنية</p>
                        <div class="space-y-4">
                            <div>
                                <p class="text-sm text-gray-600">التواصل:</p>
                                <p class="font-semibold text-gray-900">support@elhamd-auto.com</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">ساعات العمل:</p>
                                <p class="font-semibold text-gray-900">رد خلال 24 ساعة</p>
                            </div>
                            <a href="mailto:support@elhamd-auto.com" class="block w-full bg-blue-600 text-white text-center py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium">
                                أرسل بريداً
                            </a>
                        </div>
                    </div>

                    {{-- Chat --}}
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-2">
                             {{-- Message Circle icon --}}
                            <div class="p-2 bg-blue-50 rounded-lg">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6 text-blue-600">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M7.5 8.25h9m-9 3H12m-9.75 1.51c0 1.6 1.123 2.994 2.707 3.227 1.129.166 2.27.293 3.423.379.35.026.67.21.865.501L12 21l2.755-4.133a1.14 1.14 0 01.865-.501 48.172 48.172 0 003.423-.379c1.584-.233 2.707-1.626 2.707-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0012 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018z" />
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg">واتساب</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">محادثة مباشرة مع الفنيين</p>
                        <div class="space-y-4">
                            <div>
                                <p class="text-sm text-gray-600">التواصل:</p>
                                <p class="font-semibold text-gray-900">متاح على واتساب</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">ساعات العمل:</p>
                                <p class="font-semibold text-gray-900">9 ص - 8 م</p>
                            </div>
                            <a href="https://wa.me/201555767729" target="_blank" class="block w-full bg-blue-600 text-white text-center py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium">
                                ابدأ الدردشة
                            </a>
                        </div>
                    </div>
                </div>

                {{-- Support Services --}}
                <div class="grid md:grid-cols-2 gap-8 mb-12">
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <x-icon name="Check" class="h-6 w-6 text-blue-600" />
                            <h3 class="font-bold text-lg">المساعدة الفنية</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">حل المشاكل التقنية والاستفسارات</p>
                        <ul class="space-y-2">
                             @foreach(['تشخيص الأعطال', 'إرشادات الصيانة', 'مساعدة في البرمجة', 'استشارات تقنية'] as $feature)
                                <li class="flex items-center gap-2 text-sm text-gray-700">
                                    <x-icon name="Check" class="h-4 w-4 text-green-600" />
                                    <span>{{ $feature }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                             {{-- Clock icon --}}
                            <div class="h-6 w-6 text-blue-600">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg">دعم الطوارئ</h3>
                        </div>
                        <p class="text-gray-500 text-sm mb-4">مساعدة عاجلة على الطريق</p>
                        <ul class="space-y-2">
                             @foreach(['خدمة 24/7', 'سحب السيارة', 'إصلاح عاجل', 'سيارة بديلة'] as $feature)
                                <li class="flex items-center gap-2 text-sm text-gray-700">
                                    <x-icon name="Check" class="h-4 w-4 text-green-600" />
                                    <span>{{ $feature }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>

                {{-- Process --}}
                <div class="bg-white rounded-lg shadow-sm p-8 mb-8 border border-gray-100">
                    <h2 class="text-2xl font-bold mb-6 text-center">الإجراءات المتبعة عند طلب الدعم</h2>
                    <div class="grid md:grid-cols-4 gap-4">
                        <div class="text-center">
                            <div class="bg-blue-100 rounded-full w-12 h-12 flex items-center justify-center mx-auto mb-2 text-blue-600 font-bold">1</div>
                            <h3 class="font-semibold text-gray-900">التواصل</h3>
                            <p class="text-sm text-gray-600">اختر قناة التواصل المناسبة</p>
                        </div>
                        <div class="text-center">
                            <div class="bg-blue-100 rounded-full w-12 h-12 flex items-center justify-center mx-auto mb-2 text-blue-600 font-bold">2</div>
                            <h3 class="font-semibold text-gray-900">التشخيص</h3>
                            <p class="text-sm text-gray-600">شرح المشكلة بالتفصيل</p>
                        </div>
                        <div class="text-center">
                            <div class="bg-blue-100 rounded-full w-12 h-12 flex items-center justify-center mx-auto mb-2 text-blue-600 font-bold">3</div>
                            <h3 class="font-semibold text-gray-900">الحل</h3>
                            <p class="text-sm text-gray-600">تقديم الحل المناسب</p>
                        </div>
                        <div class="text-center">
                            <div class="bg-blue-100 rounded-full w-12 h-12 flex items-center justify-center mx-auto mb-2 text-blue-600 font-bold">4</div>
                            <h3 class="font-semibold text-gray-900">المتابعة</h3>
                            <p class="text-sm text-gray-600">متابعة الحل حتى النهاية</p>
                        </div>
                    </div>
                </div>

                {{-- Emergency CTA --}}
                <div class="bg-blue-50 rounded-2xl p-8 text-center border border-blue-100">
                    <h3 class="text-xl font-bold text-blue-900 mb-4">هل تحتاج مساعدة عاجلة؟</h3>
                    <p class="text-blue-700 mb-6">
                        لا تتردد في التواصل معنا في أي وقت - فريق الدعم جاهز لمساعدتك
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <a href="tel:+201555767729" class="bg-red-600 text-white px-8 py-3 rounded-lg hover:bg-red-700 transition-colors font-semibold shadow-sm hover:shadow-md">
                            طوارئ 24/7
                        </a>
                        <a href="{{ route('contact') }}" class="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700 transition-colors font-semibold">
                            نموذج الدعم
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-public-layout>
