<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application.
| These routes are loaded by the RouteServiceProvider and all of them
| will be assigned the "api" middleware group.
|
*/

Route::middleware('auth:sanctum')->group(function () {
    // Current User
    Route::get('/user', [ApiController::class, 'user']);

    // Vehicles (Public Read, Auth Write)
    Route::get('/vehicles', [ApiController::class, 'vehicles']);
    Route::get('/vehicles/{vehicle}', [ApiController::class, 'vehicleDetails']);

    // Customer Invoices
    Route::get('/invoices', [ApiController::class, 'invoices']);

    // Customer Bookings
    Route::get('/bookings', [ApiController::class, 'bookings']);
});

// Public API (with rate limiting)
Route::middleware('throttle:api')->group(function () {
    Route::get('/vehicles/available', [ApiController::class, 'availableVehicles']);
    Route::get('/service-types', [ApiController::class, 'serviceTypes']);
});
