<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', [\App\Http\Controllers\PublicController::class, 'welcome']);

Route::get('/dashboard', [\App\Http\Controllers\PublicController::class, 'dashboard'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Public Routes
Route::controller(\App\Http\Controllers\PublicController::class)->group(function () {
    Route::get('/', 'index')->name('home');
    Route::view('/offline', 'offline')->name('offline');
    Route::get('/about', 'about')->name('about');
    Route::get('/contact', 'contact')->name('contact');
    Route::post('/contact', 'contactSubmit')->middleware('throttle:contact')->name('contact.submit');
    Route::get('/consultation', 'consultation')->name('consultation');
    Route::post('/consultation', 'consultationSubmit')->middleware('throttle:contact')->name('consultation.submit');
    Route::get('/parts', 'parts')->name('parts');
    Route::get('/warranty', 'warranty')->name('warranty');
    Route::get('/faq', 'faq')->name('faq');
    Route::get('/support', 'support')->name('public.support');
    Route::get('/terms', 'terms')->name('terms');
    Route::get('/service-booking', [\App\Http\Controllers\PublicController::class, 'serviceBooking'])->name('public.service-booking');
    Route::get('/test-drive', [\App\Http\Controllers\PublicController::class, 'testDrive'])->name('public.test-drive');
    Route::get('/privacy', 'privacy')->name('privacy');
    Route::get('/tata-motors', 'tataMotors')->name('tata-motors');
    Route::get('/services', [\App\Http\Controllers\Public\ServicesController::class, 'index'])->name('services.index');
    Route::get('/maintenance', [\App\Http\Controllers\Public\MaintenanceController::class, 'index'])->name('maintenance.index');
    Route::get('/booking', [\App\Http\Controllers\Public\BookingController::class, 'index'])->name('booking.index');

    // Sitemap
    Route::get('/sitemap.xml', [\App\Http\Controllers\SitemapController::class, 'index'])->name('sitemap');

    // Arabic Aliases
    Route::get('/الشروط-والأحكام', [\App\Http\Controllers\PublicController::class, 'termsRedirect']);
    Route::get('/سياسة-الخصوصية', [\App\Http\Controllers\PublicController::class, 'privacyRedirect']);
});

Route::controller(\App\Http\Controllers\Public\VehicleController::class)->prefix('vehicles')->name('vehicles.')->group(function () {
    Route::get('/', 'index')->name('index');
    Route::get('/{id}', 'show')->name('show');
});

// Customer Routes
Route::middleware(['auth', 'verified'])->prefix('customer')->name('customer.')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Customer\DashboardController::class, 'index'])->name('dashboard');

    // Invoices
    Route::get('/invoices', [\App\Http\Controllers\Customer\InvoiceController::class, 'index'])->name('invoices');
    Route::get('/invoices/{id}', [\App\Http\Controllers\Customer\InvoiceController::class, 'show'])->name('invoices.show');

    // Orders
    Route::get('/orders', [\App\Http\Controllers\Customer\OrderController::class, 'index'])->name('orders');
    Route::get('/orders/{id}', [\App\Http\Controllers\Customer\OrderController::class, 'show'])->name('orders.show');

    // Profile
    Route::get('/profile', [\App\Http\Controllers\Customer\ProfileController::class, 'edit'])->name('profile');
    Route::patch('/profile', [\App\Http\Controllers\Customer\ProfileController::class, 'update'])->name('profile.update');
    Route::patch('/profile/password', [\App\Http\Controllers\Customer\ProfileController::class, 'updatePassword'])->name('profile.password');

    // Bookings
    Route::get('/bookings', [\App\Http\Controllers\Customer\BookingController::class, 'index'])->name('bookings');
    Route::get('/bookings/{id}', [\App\Http\Controllers\Customer\BookingController::class, 'show'])->name('bookings.show');
    Route::post('/bookings', [\App\Http\Controllers\Customer\BookingController::class, 'store'])->middleware('throttle:public-action')->name('bookings.store');

    // Support
    Route::get('/support', [\App\Http\Controllers\Customer\SupportController::class, 'index'])->name('support');
    Route::get('/support/{id}', [\App\Http\Controllers\Customer\SupportController::class, 'show'])->name('support.show');
    Route::post('/support', [\App\Http\Controllers\Customer\SupportController::class, 'store'])->middleware('throttle:public-action')->name('support.store');
    Route::post('/support/{id}/comment', [\App\Http\Controllers\Customer\SupportController::class, 'comment'])->name('support.comment');

    // Warranties
    Route::get('/warranties', [\App\Http\Controllers\Customer\WarrantyController::class, 'index'])->name('warranties');
    Route::post('/warranties/claim', [\App\Http\Controllers\Customer\WarrantyController::class, 'claimStore'])->middleware('throttle:public-action')->name('warranties.claim');

    // Insurance
    Route::get('/insurance', [\App\Http\Controllers\Customer\InsuranceController::class, 'index'])->name('insurance');
});

// Employee Routes
Route::middleware(['auth', 'employee'])->prefix('employee')->name('employee.')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Employee\EmployeeController::class, 'dashboard'])->name('dashboard');
    Route::get('/leaves', [\App\Http\Controllers\Employee\EmployeeController::class, 'leaves'])->name('leaves.index');
    Route::post('/leaves', [\App\Http\Controllers\Employee\EmployeeController::class, 'requestLeave'])->name('leaves.store');
    Route::get('/payroll', [\App\Http\Controllers\Employee\EmployeeController::class, 'payroll'])->name('payroll.index');

    // Attendance Self-Service
    Route::get('/attendance', [\App\Http\Controllers\Employee\EmployeeController::class, 'attendance'])->name('attendance.index');
    Route::post('/attendance/clock-in', [\App\Http\Controllers\Employee\EmployeeController::class, 'clockIn'])->name('attendance.clockin');
    Route::post('/attendance/clock-out', [\App\Http\Controllers\Employee\EmployeeController::class, 'clockOut'])->name('attendance.clockout');

    // Performance
    Route::get('/performance', [\App\Http\Controllers\Employee\EmployeeController::class, 'performance'])->name('performance.index');

    // Training
    Route::get('/training', [\App\Http\Controllers\Employee\EmployeeController::class, 'training'])->name('training.index');

    // Salary Advances
    Route::get('/salary-advances', [\App\Http\Controllers\Employee\EmployeeController::class, 'salaryAdvances'])->name('salary-advances.index');
    Route::post('/salary-advances', [\App\Http\Controllers\Employee\EmployeeController::class, 'requestAdvance'])->name('salary-advances.store');
});

// Admin Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');

    // Identity & Access
    Route::middleware('can:users.manage')->group(function () {
        Route::resource('users', \App\Http\Controllers\Admin\UserController::class);
        Route::resource('roles', \App\Http\Controllers\Admin\RoleController::class)->except(['show']);
    });

    // Operations
    Route::middleware('can:operations.manage')->group(function () {
        Route::resource('branches', \App\Http\Controllers\Admin\BranchController::class)->except(['show']);
        Route::post('vehicles/decode-vin', [\App\Http\Controllers\Admin\VehicleController::class, 'decodeVin'])->name('vehicles.decode-vin');
        Route::resource('vehicles', \App\Http\Controllers\Admin\VehicleController::class);
        Route::resource('bookings', \App\Http\Controllers\Admin\BookingController::class)->only(['index', 'show', 'update', 'destroy']);
        Route::resource('service-types', \App\Http\Controllers\Admin\ServiceTypeController::class)->except(['show']);

        Route::get('calendar', [\App\Http\Controllers\Admin\OperationsController::class, 'calendar'])->name('calendar');
        Route::post('calendar', [\App\Http\Controllers\Admin\OperationsController::class, 'calendarStore'])->name('calendar.store');
        Route::get('contracts', [\App\Http\Controllers\Admin\OperationsController::class, 'contracts'])->name('contracts');
        Route::post('contracts', [\App\Http\Controllers\Admin\OperationsController::class, 'contractStore'])->name('contracts.store');
        Route::get('insurance', [\App\Http\Controllers\Admin\OperationsController::class, 'insurance'])->name('insurance');
        Route::get('maintenance-admin', [\App\Http\Controllers\Admin\OperationsController::class, 'maintenance'])->name('maintenance-admin');
        Route::get('maintenance-records/create', [\App\Http\Controllers\Admin\MaintenanceRecordController::class, 'create'])->name('admin.maintenance.create');
        Route::post('maintenance-records', [\App\Http\Controllers\Admin\MaintenanceRecordController::class, 'store'])->name('admin.maintenance.store');
        
        // Procurement
        Route::resource('suppliers', \App\Http\Controllers\Admin\SupplierController::class);
        Route::resource('purchase-orders', \App\Http\Controllers\Admin\PurchaseOrderController::class);
        Route::get('purchase-orders/{id}/receive', [\App\Http\Controllers\Admin\GoodsReceiptController::class, 'create'])->name('purchase-orders.receive');
        Route::get('purchase-orders/{id}/bill', [\App\Http\Controllers\Admin\BillController::class, 'createFromPurchaseOrder'])->name('purchase-orders.bill.create');
        Route::resource('bills', \App\Http\Controllers\Admin\BillController::class);
        Route::post('bills/{bill}/post', [\App\Http\Controllers\Admin\BillController::class, 'post'])->name('bills.post');
    });

    // Finance
    Route::middleware('can:finance.manage')->group(function () {
        Route::resource('finance', \App\Http\Controllers\Admin\FinanceController::class)->only(['index', 'show', 'create', 'store']);
        Route::get('finance/payments', [\App\Http\Controllers\Admin\FinanceController::class, 'paymentsIndex'])->name('finance.payments.index');
        Route::post('finance/payments', [\App\Http\Controllers\Admin\FinanceController::class, 'storePayment'])->name('finance.payments.store');
        Route::get('finance/{id}/pdf', [\App\Http\Controllers\Admin\FinanceController::class, 'exportPdf'])->name('finance.invoices.pdf');

        Route::prefix('accounting')->name('accounting.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\AccountingController::class, 'index'])->name('index');
            Route::post('accounts', [\App\Http\Controllers\Admin\AccountingController::class, 'store'])->name('accounts.store');
            Route::put('accounts/{id}', [\App\Http\Controllers\Admin\AccountingController::class, 'update'])->name('update');
            Route::delete('accounts/{id}', [\App\Http\Controllers\Admin\AccountingController::class, 'destroy'])->name('destroy');
            Route::get('journals', [\App\Http\Controllers\Admin\AccountingController::class, 'journalIndex'])->name('journals');
            Route::post('journals', [\App\Http\Controllers\Admin\AccountingController::class, 'journalStore'])->name('journals.store');
            Route::patch('journals/{id}/approve', [\App\Http\Controllers\Admin\AccountingController::class, 'journalApprove'])->name('journals.approve');
        });

        Route::get('expenses', [\App\Http\Controllers\Admin\ExpenseController::class, 'index'])->name('expenses.index');
        Route::post('expenses', [\App\Http\Controllers\Admin\ExpenseController::class, 'store'])->name('expenses.store');
        Route::get('revenue', [\App\Http\Controllers\Admin\RevenueController::class, 'index'])->name('revenue.index');
        Route::post('revenue', [\App\Http\Controllers\Admin\RevenueController::class, 'store'])->name('revenue.store');
        Route::prefix('tax')->name('tax.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\TaxController::class, 'index'])->name('index');
            Route::post('rates', [\App\Http\Controllers\Admin\TaxController::class, 'storeRate'])->name('rates.store');
            Route::post('records', [\App\Http\Controllers\Admin\TaxController::class, 'storeRecord'])->name('records.store');
            Route::post('rates', [\App\Http\Controllers\Admin\TaxController::class, 'storeRate'])->name('rates.store');
            Route::post('records', [\App\Http\Controllers\Admin\TaxController::class, 'storeRecord'])->name('records.store');
        });

        Route::get('reports', [\App\Http\Controllers\Admin\ReportController::class, 'index'])->name('reports.index');
        Route::post('reports/profit-loss', [\App\Http\Controllers\Admin\ReportController::class, 'exportProfitLoss'])->name('reports.export.profit-loss');
        Route::get('reports/inventory-valuation', [\App\Http\Controllers\Admin\ReportController::class, 'exportInventoryValuation'])->name('reports.export.inventory-valuation');

        Route::resource('quotations', \App\Http\Controllers\Admin\QuotationController::class)->only(['index', 'create', 'store', 'show', 'destroy']);
        Route::post('quotations/{quotation}/convert', [\App\Http\Controllers\Admin\QuotationController::class, 'convertToInvoice'])->name('quotations.convert');
    });

    // CRM, Marketing & Sales
    Route::middleware('can:crm.manage')->group(function () {
        Route::prefix('crm')->name('crm.')->group(function () {
            Route::get('customers', [\App\Http\Controllers\Admin\CrmController::class, 'customersIndex'])->name('customers.index');
            Route::get('customers/{id}', [\App\Http\Controllers\Admin\CrmController::class, 'customerShow'])->name('customers.show');
            Route::get('leads', [\App\Http\Controllers\Admin\CrmController::class, 'leadsIndex'])->name('leads.index');
            Route::post('leads', [\App\Http\Controllers\Admin\CrmController::class, 'leadStore'])->name('leads.store');
            Route::get('opportunities', [\App\Http\Controllers\Admin\CrmController::class, 'opportunitiesIndex'])->name('opportunities.index');
            Route::post('opportunities', [\App\Http\Controllers\Admin\CrmController::class, 'opportunityStore'])->name('opportunities.store');
            Route::post('leads/{lead}/activities', [\App\Http\Controllers\Admin\LeadActivityController::class, 'store'])->name('leads.activities.store');
        });

        Route::get('marketing', [\App\Http\Controllers\Admin\MarketingController::class, 'index'])->name('marketing');
        Route::post('marketing', [\App\Http\Controllers\Admin\MarketingController::class, 'store'])->name('marketing.store');
        Route::get('sales', [\App\Http\Controllers\Admin\MarketingController::class, 'sales'])->name('sales');
        Route::get('feedback', [\App\Http\Controllers\Admin\MarketingController::class, 'feedback'])->name('feedback');
        Route::get('customer-service', [\App\Http\Controllers\Admin\MarketingController::class, 'customerService'])->name('customer-service');
    });

    // Support
    Route::middleware('can:support.manage')->prefix('support')->name('support.')->group(function () {
        Route::get('tickets', [\App\Http\Controllers\Admin\SupportController::class, 'index'])->name('tickets.index');
        Route::get('tickets/{id}', [\App\Http\Controllers\Admin\SupportController::class, 'show'])->name('tickets.show');
        Route::post('tickets', [\App\Http\Controllers\Admin\SupportController::class, 'store'])->name('tickets.store');
        Route::post('tickets/{id}/comments', [\App\Http\Controllers\Admin\SupportController::class, 'storeComment'])->name('tickets.storeComment');
        Route::patch('tickets/{id}/status', [\App\Http\Controllers\Admin\SupportController::class, 'updateStatus'])->name('tickets.updateStatus');
        Route::get('complaints', [\App\Http\Controllers\Admin\SupportController::class, 'complaintsIndex'])->name('complaints.index');
        Route::get('complaints/{id}', [\App\Http\Controllers\Admin\SupportController::class, 'complaintShow'])->name('complaints.show');
        Route::post('complaints/{id}/follow-up', [\App\Http\Controllers\Admin\SupportController::class, 'complaintFollowUpStore'])->name('complaints.followUp');
    });

    // CMS
    Route::middleware('can:content.manage')->prefix('cms')->name('cms.')->group(function () {
        Route::get('settings', [\App\Http\Controllers\Admin\CMSController::class, 'settingsIndex'])->name('settings.index');
        Route::post('settings', [\App\Http\Controllers\Admin\CMSController::class, 'settingsUpdate'])->name('settings.update');
        Route::get('sliders', [\App\Http\Controllers\Admin\CMSController::class, 'slidersIndex'])->name('sliders.index');
        Route::post('sliders', [\App\Http\Controllers\Admin\CMSController::class, 'sliderStore'])->name('sliders.store');
        Route::get('kb', [\App\Http\Controllers\Admin\CMSController::class, 'kbIndex'])->name('kb.index');
        Route::post('kb/categories', [\App\Http\Controllers\Admin\CMSController::class, 'kbCategoryStore'])->name('kb.category.store');

        Route::get('stats', [\App\Http\Controllers\Admin\CMSController::class, 'statsIndex'])->name('stats.index');
        Route::post('stats', [\App\Http\Controllers\Admin\CMSController::class, 'statsStore'])->name('stats.store');
        Route::delete('stats/{id}', [\App\Http\Controllers\Admin\CMSController::class, 'statsDestroy'])->name('stats.destroy');

        Route::get('values', [\App\Http\Controllers\Admin\CMSController::class, 'valuesIndex'])->name('values.index');
        Route::post('values', [\App\Http\Controllers\Admin\CMSController::class, 'valuesStore'])->name('values.store');
        Route::delete('values/{id}', [\App\Http\Controllers\Admin\CMSController::class, 'valuesDestroy'])->name('values.destroy');

        Route::get('timeline', [\App\Http\Controllers\Admin\CMSController::class, 'timelineIndex'])->name('timeline.index');
        Route::post('timeline', [\App\Http\Controllers\Admin\CMSController::class, 'timelineStore'])->name('timeline.store');
        Route::delete('timeline/{id}', [\App\Http\Controllers\Admin\CMSController::class, 'timelineDestroy'])->name('timeline.destroy');

        Route::get('service-items', [\App\Http\Controllers\Admin\CMSController::class, 'serviceItemsIndex'])->name('service-items.index');
        Route::post('service-items', [\App\Http\Controllers\Admin\CMSController::class, 'serviceItemsStore'])->name('service-items.store');
        Route::delete('service-items/{id}', [\App\Http\Controllers\Admin\CMSController::class, 'serviceItemsDestroy'])->name('service-items.destroy');

        Route::get('features', [\App\Http\Controllers\Admin\CMSController::class, 'featuresIndex'])->name('features.index');
        Route::post('features', [\App\Http\Controllers\Admin\CMSController::class, 'featuresStore'])->name('features.store');
        Route::delete('features/{id}', [\App\Http\Controllers\Admin\CMSController::class, 'featuresDestroy'])->name('features.destroy');

        Route::get('contact', [\App\Http\Controllers\Admin\CMSController::class, 'contactIndex'])->name('contact.index');
        Route::post('contact', [\App\Http\Controllers\Admin\CMSController::class, 'contactUpdate'])->name('contact.update');

        Route::resource('faqs', \App\Http\Controllers\Admin\FaqController::class)->except(['show']);
        Route::get('company-info', [\App\Http\Controllers\Admin\CompanyInfoController::class, 'edit'])->name('company-info.edit');
        Route::put('company-info', [\App\Http\Controllers\Admin\CompanyInfoController::class, 'update'])->name('company-info.update');
    });

    // HR
    Route::middleware('can:hr.manage')->prefix('hr')->name('hr.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\HRController::class, 'index'])->name('index');
        Route::get('employees', [\App\Http\Controllers\Admin\HRController::class, 'employees'])->name('employees.index');
        Route::post('employees', [\App\Http\Controllers\Admin\HRController::class, 'employeeStore'])->name('employees.store');
        Route::get('employees/{id}', [\App\Http\Controllers\Admin\HRController::class, 'employeeShow'])->name('employees.show');
        Route::get('attendance', [\App\Http\Controllers\Admin\HRController::class, 'attendance'])->name('attendance');
        Route::post('attendance', [\App\Http\Controllers\Admin\HRController::class, 'attendanceStore'])->name('attendance.store');
        Route::get('performance', [\App\Http\Controllers\Admin\HRController::class, 'performance'])->name('performance');
        Route::post('performance', [\App\Http\Controllers\Admin\HRController::class, 'performanceStore'])->name('performance.store');
        Route::get('payroll', [\App\Http\Controllers\Admin\HRController::class, 'payroll'])->name('payroll');
        Route::post('payroll', [\App\Http\Controllers\Admin\HRController::class, 'payrollStore'])->name('payroll.store');
        Route::get('departments', [\App\Http\Controllers\Admin\HRController::class, 'departments'])->name('departments');
        Route::post('departments', [\App\Http\Controllers\Admin\HRController::class, 'departmentStore'])->name('departments.store');
        Route::delete('departments/{id}', [\App\Http\Controllers\Admin\HRController::class, 'departmentDestroy'])->name('departments.destroy');
        Route::get('leaves', [\App\Http\Controllers\Admin\HRController::class, 'leaves'])->name('leaves');
        Route::patch('leaves/{id}', [\App\Http\Controllers\Admin\HRController::class, 'leaveAction'])->name('leaves.action');
    });

    // System
    Route::middleware('can:system.manage')->group(function () {
        Route::get('logs', [\App\Http\Controllers\Admin\SystemController::class, 'logs'])->name('logs');
        Route::get('security-logs', [\App\Http\Controllers\Admin\SystemController::class, 'securityLogs'])->name('security-logs');
        Route::get('notifications', [\App\Http\Controllers\Admin\SystemController::class, 'notifications'])->name('notifications');
        Route::patch('notifications/{id}/read', [\App\Http\Controllers\Admin\SystemController::class, 'markNotificationRead'])->name('notifications.read');
        Route::get('media', [\App\Http\Controllers\Admin\SystemController::class, 'media'])->name('media');
        Route::post('media', [\App\Http\Controllers\Admin\SystemController::class, 'mediaStore'])->name('media.store');
        Route::get('media/{media}/download', [\App\Http\Controllers\Admin\SystemController::class, 'mediaDownload'])->name('media.download')->middleware('signed');
        Route::get('tasks', [\App\Http\Controllers\Admin\SystemController::class, 'tasks'])->name('tasks');
        Route::post('tasks', [\App\Http\Controllers\Admin\SystemController::class, 'taskStore'])->name('tasks.store');
        Route::get('activity-logs', [\App\Http\Controllers\Admin\SystemController::class, 'logs'])->name('activity-logs');
    });

    // Global Search
    Route::middleware(['can:operations.manage', 'throttle:search'])
        ->get('search', \App\Http\Controllers\Admin\SearchController::class)
        ->name('search');
});

require __DIR__.'/auth.php';
