<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        Edit Vehicle: <?php echo e($vehicle->year); ?> <?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?>

     <?php $__env->endSlot(); ?>

    <div class="max-w-4xl mx-auto">
        <form method="POST" action="<?php echo e(route('admin.vehicles.update', $vehicle->id)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Basic Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Make -->
                        <div>
                            <label for="make" class="block text-sm font-medium text-gray-700">Make</label>
                            <input type="text" name="make" id="make" value="<?php echo e(old('make', $vehicle->make)); ?>" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Model -->
                        <div>
                            <label for="model" class="block text-sm font-medium text-gray-700">Model</label>
                            <input type="text" name="model" id="model" value="<?php echo e(old('model', $vehicle->model)); ?>" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Year -->
                        <div>
                            <label for="year" class="block text-sm font-medium text-gray-700">Year</label>
                            <input type="number" name="year" id="year" value="<?php echo e(old('year', $vehicle->year)); ?>" required min="1900" max="<?php echo e(date('Y') + 1); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                         <!-- Stock Number -->
                        <div>
                            <label for="stock_number" class="block text-sm font-medium text-gray-700">Stock Number</label>
                            <input type="text" name="stock_number" id="stock_number" value="<?php echo e(old('stock_number', $vehicle->stock_number)); ?>" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Stock Quantity -->
                        <div>
                            <label for="stock_quantity" class="block text-sm font-medium text-gray-700">Quantity</label>
                            <input type="number" name="stock_quantity" id="stock_quantity" value="<?php echo e(old('stock_quantity', $vehicle->stock_quantity)); ?>" required min="0" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- VIN -->
                        <div>
                            <label for="vin" class="block text-sm font-medium text-gray-700">VIN</label>
                            <input type="text" name="vin" id="vin" value="<?php echo e(old('vin', $vehicle->vin)); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white shadow sm:rounded-lg overflow-hidden mb-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Details & Pricing</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                         <!-- Price -->
                        <div>
                            <label for="price" class="block text-sm font-medium text-gray-700">Price (EGP)</label>
                            <input type="number" name="price" id="price" value="<?php echo e(old('price', $vehicle->pricing->price ?? 0)); ?>" required step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>

                        <!-- Category -->
                        <div>
                            <label for="category" class="block text-sm font-medium text-gray-700">Category</label>
                            <select name="category" id="category" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="SEDAN" <?php echo e(old('category', $vehicle->category) == 'SEDAN' ? 'selected' : ''); ?>>Sedan</option>
                                <option value="SUV" <?php echo e(old('category', $vehicle->category) == 'SUV' ? 'selected' : ''); ?>>SUV</option>
                                <option value="TRUCK" <?php echo e(old('category', $vehicle->category) == 'TRUCK' ? 'selected' : ''); ?>>Truck</option>
                                <option value="COUPE" <?php echo e(old('category', $vehicle->category) == 'COUPE' ? 'selected' : ''); ?>>Coupe</option>
                                <option value="VAN" <?php echo e(old('category', $vehicle->category) == 'VAN' ? 'selected' : ''); ?>>Van</option>
                            </select>
                        </div>

                        <!-- Status -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                            <select name="status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="AVAILABLE" <?php echo e(old('status', $vehicle->status) == 'AVAILABLE' ? 'selected' : ''); ?>>Available</option>
                                <option value="SOLD" <?php echo e(old('status', $vehicle->status) == 'SOLD' ? 'selected' : ''); ?>>Sold</option>
                                <option value="RESERVED" <?php echo e(old('status', $vehicle->status) == 'RESERVED' ? 'selected' : ''); ?>>Reserved</option>
                                <option value="MAINTENANCE" <?php echo e(old('status', $vehicle->status) == 'MAINTENANCE' ? 'selected' : ''); ?>>Maintenance</option>
                            </select>
                        </div>

                        <!-- Fuel Type -->
                        <div>
                            <label for="fuel_type" class="block text-sm font-medium text-gray-700">Fuel Type</label>
                             <select name="fuel_type" id="fuel_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="PETROL" <?php echo e(old('fuel_type', $vehicle->fuel_type) == 'PETROL' ? 'selected' : ''); ?>>Petrol</option>
                                <option value="DIESEL" <?php echo e(old('fuel_type', $vehicle->fuel_type) == 'DIESEL' ? 'selected' : ''); ?>>Diesel</option>
                                <option value="ELECTRIC" <?php echo e(old('fuel_type', $vehicle->fuel_type) == 'ELECTRIC' ? 'selected' : ''); ?>>Electric</option>
                                <option value="HYBRID" <?php echo e(old('fuel_type', $vehicle->fuel_type) == 'HYBRID' ? 'selected' : ''); ?>>Hybrid</option>
                            </select>
                        </div>

                        <!-- Transmission -->
                        <div>
                            <label for="transmission" class="block text-sm font-medium text-gray-700">Transmission</label>
                             <select name="transmission" id="transmission" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="AUTOMATIC" <?php echo e(old('transmission', $vehicle->transmission) == 'AUTOMATIC' ? 'selected' : ''); ?>>Automatic</option>
                                <option value="MANUAL" <?php echo e(old('transmission', $vehicle->transmission) == 'MANUAL' ? 'selected' : ''); ?>>Manual</option>
                                <option value="CVT" <?php echo e(old('transmission', $vehicle->transmission) == 'CVT' ? 'selected' : ''); ?>>CVT</option>
                            </select>
                        </div>

                        <!-- Mileage -->
                         <div>
                            <label for="mileage" class="block text-sm font-medium text-gray-700">Mileage (km)</label>
                            <input type="number" name="mileage" id="mileage" value="<?php echo e(old('mileage', $vehicle->mileage)); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="mt-6">
                        <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" id="description" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50"><?php echo e(old('description', $vehicle->description)); ?></textarea>
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <a href="<?php echo e(route('admin.vehicles.index')); ?>" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 mr-4">Cancel</a>
                <button type="submit" class="bg-blue-600 border border-transparent rounded-md shadow-sm py-2 px-4 text-sm font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">Update Vehicle</button>
            </div>
        </form>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\Users\shoko\OneDrive\Desktop\Elhamd-main\Elhamd-Laravel\resources\views/admin/vehicles/edit.blade.php ENDPATH**/ ?>