<?php
    $images = $vehicle->images && $vehicle->images->count() > 0 ? $vehicle->images : collect([
        (object)['image_url' => asset('assets/images/placeholder-car.jpg'), 'alt_text' => 'صورة غير متوفرة']
    ]);
    
    // Premium Status Badges
    $statusConfig = [
        'AVAILABLE' => ['label' => 'متاحة للبيع', 'class' => 'bg-emerald-100 text-emerald-800 border-emerald-200 ring-emerald-500/20'],
        'RESERVED' => ['label' => 'محجوزة', 'class' => 'bg-amber-100 text-amber-800 border-amber-200 ring-amber-500/20'],
        'SOLD' => ['label' => 'تم البيع', 'class' => 'bg-slate-100 text-slate-600 border-slate-200 ring-slate-500/20 grayscale'],
        'MAINTENANCE' => ['label' => 'في الصيانة', 'class' => 'bg-blue-100 text-blue-800 border-blue-200 ring-blue-500/20']
    ];

    $statusInfo = $statusConfig[$vehicle->status] ?? ['label' => $vehicle->status, 'class' => 'bg-gray-100 text-gray-800'];
?>

<?php if (isset($component)) { $__componentOriginal42b37f006f8ebbe12b66cfa27a5def06 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06 = $attributes; } ?>
<?php $component = App\View\Components\PublicLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('public-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PublicLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="min-h-screen bg-slate-50 pb-20 pt-16 md:pt-20 font-sans" x-data="{ 
        selectedImageIndex: 0,
        images: <?php echo e(json_encode($images)); ?>,
        showContactModal: false,
        activeTab: 'specs'
    }">
        <!-- Breadcrumb & Title Bar -->
        <div class="bg-white border-b border-slate-200 sticky top-16 z-30 shadow-sm/50 backdrop-blur-xl bg-white/90">
            <div class="container mx-auto px-4 h-auto md:h-20 py-4 md:py-0 flex flex-col md:flex-row items-start md:items-center justify-between gap-4">
                <div class="flex flex-col gap-1">
                     <nav class="flex items-center gap-2 text-sm text-slate-500">
                        <a href="/" class="hover:text-red-600 transition-colors">الرئيسية</a>
                        <svg class="h-3 w-3 rtl:rotate-180 text-slate-300" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                        <a href="<?php echo e(route('vehicles.index')); ?>" class="hover:text-red-600 transition-colors">المركبات</a>
                        <svg class="h-3 w-3 rtl:rotate-180 text-slate-300" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                        <span class="font-semibold text-slate-900 truncate max-w-[150px] md:max-w-xs">
                            <?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?>

                        </span>
                    </nav>
                    <h1 class="text-xl md:text-2xl font-bold text-slate-900 tracking-tight leading-none">
                        <?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?> <span class="text-slate-400 font-light mx-1">|</span> <?php echo e($vehicle->year); ?>

                    </h1>
                </div>

                <div class="flex items-center gap-3 w-full md:w-auto">
                    <button class="flex-1 md:flex-none py-2.5 px-6 bg-slate-100 hover:bg-slate-200 text-slate-700 font-bold rounded-lg transition-all text-sm flex items-center justify-center gap-2 group border border-slate-200" title="مشاركة">
                        <svg class="h-4 w-4 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z" /></svg>
                        <span>مشاركة</span>
                    </button>
                    <button @click="showContactModal = true" class="flex-1 md:flex-none py-2.5 px-6 bg-red-600 hover:bg-red-700 text-white font-bold rounded-lg transition-all text-sm shadow-md hover:shadow-lg hover:shadow-red-500/20 active:scale-95">
                        احجز الآن
                    </button>
                </div>
            </div>
        </div>

        <div class="container mx-auto px-4 py-8 md:py-12">
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-8 lg:gap-12 items-start">
                
                <!-- Main Content Column -->
                <div class="lg:col-span-8 space-y-8">
                    
                    <!-- Gallery Section -->
                    <div class="bg-white rounded-3xl shadow-[0_2px_15px_rgba(0,0,0,0.06)] border border-slate-100 overflow-hidden group">
                        <!-- Main Image Stage -->
                        <div class="relative aspect-[16/10] bg-slate-900 overflow-hidden">
                            <template x-for="(image, index) in images" :key="index">
                                <div class="absolute inset-0 transition-opacity duration-500 ease-in-out"
                                     x-show="selectedImageIndex === index"
                                     x-transition:enter="opacity-0 scale-105"
                                     x-transition:enter-end="opacity-100 scale-100"
                                     x-transition:leave="opacity-100"
                                     x-transition:leave-end="opacity-0">
                                    <img :src="image.image_url" 
                                         :alt="image.alt_text"
                                         class="w-full h-full object-contain bg-slate-900/50 backdrop-blur-sm">
                                </div>
                            </template>
                            
                            <!-- Badges -->
                            <div class="absolute top-4 right-4 flex flex-col gap-2 z-10 pointer-events-none">
                                <span class="inline-flex items-center px-3 py-1.5 text-xs font-bold rounded-full ring-1 shadow-sm backdrop-blur-md <?php echo e($statusInfo['class']); ?>">
                                    <?php echo e($statusInfo['label']); ?>

                                </span>
                                <?php if($vehicle->featured): ?>
                                    <span class="inline-flex items-center px-3 py-1.5 bg-gradient-to-r from-amber-400 to-amber-500 text-white text-xs font-bold rounded-full shadow-lg border border-white/20">
                                        <svg class="w-3 h-3 ml-1" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                        مميزة
                                    </span>
                                <?php endif; ?>
                            </div>

                            <!-- Nav Buttons -->
                            <button @click="selectedImageIndex = (selectedImageIndex === 0) ? images.length - 1 : selectedImageIndex - 1" class="absolute left-4 top-1/2 -translate-y-1/2 w-10 h-10 rounded-full bg-black/30 hover:bg-black/50 text-white flex items-center justify-center backdrop-blur-sm transition-all hover:scale-110">
                                <svg class="w-5 h-5 rtl:rotate-180" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" /></svg>
                            </button>
                            <button @click="selectedImageIndex = (selectedImageIndex === images.length - 1) ? 0 : selectedImageIndex + 1" class="absolute right-4 top-1/2 -translate-y-1/2 w-10 h-10 rounded-full bg-black/30 hover:bg-black/50 text-white flex items-center justify-center backdrop-blur-sm transition-all hover:scale-110">
                                <svg class="w-5 h-5 rtl:rotate-180" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                            </button>
                        </div>

                        <!-- Thumbnails Scroll -->
                        <div class="bg-slate-50 p-4 border-t border-slate-100">
                             <div class="flex gap-3 overflow-x-auto pb-2 custom-scrollbar snap-x">
                                <template x-for="(image, index) in images" :key="index">
                                    <button @click="selectedImageIndex = index"
                                            class="snap-start relative w-20 h-16 md:w-28 md:h-20 flex-shrink-0 rounded-lg overflow-hidden border-2 transition-all duration-300"
                                            :class="selectedImageIndex === index ? 'border-red-600 ring-2 ring-red-600/20 scale-105 shadow-md' : 'border-transparent opacity-60 hover:opacity-100 grayscale hover:grayscale-0'">
                                        <img :src="image.image_url" class="w-full h-full object-cover">
                                    </button>
                                </template>
                            </div>
                        </div>
                    </div>

                    <!-- Key Metrics Grid -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 flex flex-col items-center text-center gap-2 hover:border-red-100 transition-colors group">
                            <span class="p-3 bg-slate-50 rounded-xl group-hover:bg-red-50 transition-colors text-slate-400 group-hover:text-red-600">
                                <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 10V3L4 14h7v7l9-11h-7z" /></svg>
                            </span>
                            <div>
                                <p class="text-xs text-slate-400 font-medium mb-1">المسافة المقطوعة</p>
                                <p class="text-lg font-bold text-slate-800"><?php echo e($vehicle->mileage ? number_format($vehicle->mileage) . ' كم' : 'جديد (أصفار)'); ?></p>
                            </div>
                        </div>
                        <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 flex flex-col items-center text-center gap-2 hover:border-red-100 transition-colors group">
                            <span class="p-3 bg-slate-50 rounded-xl group-hover:bg-red-50 transition-colors text-slate-400 group-hover:text-red-600">
                                <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.384-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z" /></svg>
                            </span>
                            <div>
                                <p class="text-xs text-slate-400 font-medium mb-1">نوع الوقود</p>
                                <p class="text-lg font-bold text-slate-800"><?php echo e(__('vehicle.fuel_types.' . $vehicle->fuel_type)); ?></p>
                            </div>
                        </div>
                        <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 flex flex-col items-center text-center gap-2 hover:border-red-100 transition-colors group">
                            <span class="p-3 bg-slate-50 rounded-xl group-hover:bg-red-50 transition-colors text-slate-400 group-hover:text-red-600">
                                <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4" /></svg>
                            </span>
                            <div>
                                <p class="text-xs text-slate-400 font-medium mb-1">ناقل الحركة</p>
                                <p class="text-lg font-bold text-slate-800"><?php echo e(__('vehicle.transmission_types.' . $vehicle->transmission_type)); ?></p>
                            </div>
                        </div>
                        <div class="bg-white p-5 rounded-2xl shadow-sm border border-slate-100 flex flex-col items-center text-center gap-2 hover:border-red-100 transition-colors group">
                            <span class="p-3 bg-slate-50 rounded-xl group-hover:bg-red-50 transition-colors text-slate-400 group-hover:text-red-600">
                                <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01" /></svg>
                            </span>
                            <div>
                                <p class="text-xs text-slate-400 font-medium mb-1">اللون</p>
                                <p class="text-lg font-bold text-slate-800"><?php echo e($vehicle->color ?? 'غير محدد'); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Description & Details Tabs -->
                    <div class="bg-white rounded-3xl shadow-[0_2px_15px_rgba(0,0,0,0.06)] border border-slate-100 overflow-hidden">
                        <div class="border-b border-slate-100 bg-slate-50/50 px-8 pt-6">
                            <div class="flex space-x-reverse space-x-8">
                                <button @click="activeTab = 'specs'" 
                                        class="pb-4 font-bold transition-all text-lg border-b-[3px]"
                                        :class="activeTab === 'specs' ? 'border-red-600 text-slate-900' : 'border-transparent text-slate-500 hover:text-slate-700'">
                                    المواصفات الفنية
                                </button>
                                <button @click="activeTab = 'description'" 
                                        class="pb-4 font-bold transition-all text-lg border-b-[3px]"
                                        :class="activeTab === 'description' ? 'border-red-600 text-slate-900' : 'border-transparent text-slate-500 hover:text-slate-700'">
                                    الوصف العام
                                </button>
                            </div>
                        </div>

                        <div class="p-8">
                            <!-- Specifications Tab -->
                            <div x-show="activeTab === 'specs'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0">
                                <?php if($vehicle->specifications && $vehicle->specifications->count() > 0): ?>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                                        <?php $__currentLoopData = $vehicle->specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="flex justify-between items-center py-3 border-b border-slate-100 last:border-0 group hover:bg-slate-50/80 px-4 rounded-xl transition-colors">
                                                <span class="text-slate-500 font-medium"><?php echo e($spec->key); ?></span>
                                                <span class="text-slate-900 font-bold" dir="ltr"><?php echo e($spec->value); ?></span>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php else: ?>
                                    <div class="text-center py-16">
                                        <div class="bg-slate-50 w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-4">
                                            <svg class="w-10 h-10 text-slate-300" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" /></svg>
                                        </div>
                                        <p class="text-slate-400 text-lg">لا توجد مواصفات فنية إضافية.</p>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Description Tab -->
                            <div x-show="activeTab === 'description'" style="display: none;" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0">
                                <div class="prose prose-lg max-w-none prose-headings:text-slate-900 prose-p:text-slate-600 prose-li:text-slate-600 prose-strong:text-slate-900 font-light leading-relaxed">
                                    <?php if($vehicle->description): ?>
                                        <?php echo nl2br(e($vehicle->description)); ?>

                                    <?php else: ?>
                                         <p class="text-slate-400 italic">لا يوجد وصف متاح لهذه المركبة.</p>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="mt-8 pt-8 border-t border-slate-100">
                                    <h4 class="font-bold text-slate-900 mb-4">المميزات الرئيسية:</h4>
                                    <div class="flex flex-wrap gap-3">
                                        <?php $__currentLoopData = $vehicle->features ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-slate-50 border border-slate-200 text-slate-700 font-medium text-sm">
                                                <svg class="w-4 h-4 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                                                <?php echo e($feature); ?>

                                            </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar (Sticky) -->
                <div class="lg:col-span-4 space-y-6 lg:sticky lg:top-40">
                    <!-- Price Card -->
                    <div class="bg-white rounded-3xl shadow-[0_4px_20px_rgba(0,0,0,0.08)] overflow-hidden border border-slate-100 relative group">
                        <div class="absolute top-0 w-full h-2 bg-gradient-to-r from-red-500 to-red-600"></div>
                        <div class="p-8 text-center bg-slate-50/50">
                            <p class="text-slate-500 text-sm font-bold uppercase tracking-wider mb-2">السعر المطلوب</p>
                            <div class="flex items-baseline justify-center gap-1 dir-rtl">
                                <span class="text-4xl lg:text-5xl font-black text-slate-900 tracking-tight"><?php echo e(number_format($vehicle->price)); ?></span>
                                <span class="text-lg font-bold text-slate-400">ج.م</span>
                            </div>
                        </div>

                        <div class="p-6 space-y-4 bg-white">
                            <button @click="showContactModal = true" class="w-full py-4 bg-red-600 hover:bg-red-700 text-white rounded-2xl text-lg font-bold shadow-lg shadow-red-500/30 hover:shadow-red-500/50 transition-all duration-300 transform hover:-translate-y-1 flex items-center justify-center gap-3">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                اطلب عرض سعر
                            </button>
                            
                            <button @click="showContactModal = true" class="w-full py-4 bg-white border-2 border-slate-200 text-slate-700 hover:border-slate-800 hover:text-slate-900 rounded-2xl text-lg font-bold transition-all duration-300 flex items-center justify-center gap-3">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" /></svg>
                                حجز تجربة قيادة
                            </button>
                        </div>
                        
                        <div class="px-6 pb-6 pt-2">
                             <div class="flex items-center gap-3 p-4 rounded-xl bg-blue-50/50 border border-blue-100 text-blue-800 text-sm">
                                <svg class="w-5 h-5 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                <span>السعر يشمل ضريبة القيمة المضافة ولا يشمل رسوم التسجيل والتأمين.</span>
                            </div>
                        </div>
                    </div>

                    <!-- Dealer Info -->
                    <div class="bg-white rounded-3xl shadow-[0_2px_15px_rgba(0,0,0,0.06)] border border-slate-100 p-6">
                        <div class="flex items-center gap-5 mb-6">
                             <div class="w-16 h-16 rounded-2xl bg-slate-900 flex items-center justify-center shadow-lg">
                                <img src="/uploads/logo/elhamd-logo.png" alt="Logo" class="w-10 h-10 object-contain brightness-0 invert opacity-90" onerror="this.style.display='none'">
                             </div>
                            <div>
                                <h3 class="font-bold text-slate-900 text-lg">الحمد للسيارات</h3>
                                <p class="text-sm text-slate-500 flex items-center gap-1">
                                    <svg class="w-4 h-4 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                    وكيل معتمد
                                </p>
                            </div>
                        </div>
                        
                        <div class="space-y-4">
                            <a href="tel:<?php echo e($siteSettings->contact_phone); ?>" class="flex items-center justify-between p-4 rounded-xl bg-slate-50 hover:bg-slate-100 transition-colors group">
                                <div class="flex items-center gap-3 text-slate-700 font-medium">
                                    <span class="p-2 bg-white rounded-lg group-hover:bg-red-600 group-hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" /></svg>
                                    </span>
                                    خدمة المبيعات
                                </div>
                                <span class="text-slate-400 rtl:rotate-180">
                                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                                </span>
                            </a>
                            <div class="flex items-center justify-between p-4 rounded-xl bg-slate-50">
                                <div class="flex items-center gap-3 text-slate-700 font-medium">
                                    <span class="p-2 bg-white rounded-lg text-slate-400">
                                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                    </span>
                                    <span>ساعات العمل</span>
                                </div>
                                <span class="text-sm font-bold text-slate-900">9 ص - 10 م</span>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            
            <!-- Modal (Better Design) -->
            <div x-show="showContactModal" 
                 class="fixed inset-0 z-[100] flex items-center justify-center px-4"
                 style="display: none;"
                 x-cloak>
                 
                <div class="absolute inset-0 bg-slate-900/80 backdrop-blur-sm" 
                     @click="showContactModal = false"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0"
                     x-transition:enter-end="opacity-100"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"></div>
                
                <div class="relative bg-white rounded-3xl shadow-2xl w-full max-w-lg overflow-hidden" 
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-y-8 scale-95"
                     x-transition:enter-end="opacity-100 translate-y-0 scale-100"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100 translate-y-0 scale-100"
                     x-transition:leave-end="opacity-0 translate-y-8 scale-95">
                    
                    <div class="bg-slate-50 border-b border-slate-100 p-6 flex justify-between items-center">
                        <div>
                            <h3 class="text-xl font-bold text-slate-900">طلب استفسار</h3>
                            <p class="text-slate-500 text-sm mt-1">عن <?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?></p>
                        </div>
                        <button @click="showContactModal = false" class="w-8 h-8 rounded-full bg-slate-200 hover:bg-slate-300 flex items-center justify-center transition-colors">
                            <svg class="w-5 h-5 text-slate-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" /></svg>
                        </button>
                    </div>
                    
                    <div class="p-8">
                        <form action="<?php echo e(route('contact.submit')); ?>" method="POST" class="space-y-5">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="vehicle_id" value="<?php echo e($vehicle->id); ?>">
                            
                            <div class="grid grid-cols-2 gap-5">
                                <div class="col-span-2">
                                    <label class="block text-sm font-bold text-slate-700 mb-2">الاسم الكامل</label>
                                    <input type="text" name="name" required class="w-full rounded-xl border-slate-200 focus:ring-red-600 focus:border-red-600 bg-slate-50 py-3 px-4 transition-shadow">
                                </div>
                                <div class="col-span-2 md:col-span-1">
                                    <label class="block text-sm font-bold text-slate-700 mb-2">رقم الهاتف</label>
                                    <input type="tel" name="phone" required class="w-full rounded-xl border-slate-200 focus:ring-red-600 focus:border-red-600 bg-slate-50 py-3 px-4 transition-shadow text-left" dir="ltr" placeholder="+20">
                                </div>
                                <div class="col-span-2 md:col-span-1">
                                    <label class="block text-sm font-bold text-slate-700 mb-2">البريد الإلكتروني (اختياري)</label>
                                    <input type="email" name="email" class="w-full rounded-xl border-slate-200 focus:ring-red-600 focus:border-red-600 bg-slate-50 py-3 px-4 transition-shadow text-left" dir="ltr">
                                </div>
                                <div class="col-span-2">
                                    <label class="block text-sm font-bold text-slate-700 mb-2">الرسالة</label>
                                    <textarea name="message" rows="3" class="w-full rounded-xl border-slate-200 focus:ring-red-600 focus:border-red-600 bg-slate-50 py-3 px-4 transition-shadow resize-none">هل السيارة ما زالت متاحة؟ أرغب في معاينتها.</textarea>
                                </div>
                            </div>

                            <button type="submit" class="w-full py-4 bg-red-600 hover:bg-red-700 text-white font-bold rounded-xl transition-all shadow-lg shadow-red-500/30 transform hover:-translate-y-1">
                                إرسال الطلب
                            </button>
                            
                            <p class="text-xs text-center text-slate-400 mt-4">سيتم التواصل معك خلال ساعات العمل الرسمية</p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06)): ?>
<?php $attributes = $__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06; ?>
<?php unset($__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42b37f006f8ebbe12b66cfa27a5def06)): ?>
<?php $component = $__componentOriginal42b37f006f8ebbe12b66cfa27a5def06; ?>
<?php unset($__componentOriginal42b37f006f8ebbe12b66cfa27a5def06); ?>
<?php endif; ?>
<?php /**PATH C:\Users\shoko\OneDrive\Desktop\Elhamd-main\Elhamd-Laravel\resources\views/public/vehicles/show.blade.php ENDPATH**/ ?>