<footer class="bg-slate-900 text-white pt-20 pb-10 relative overflow-hidden font-sans border-t-4 border-red-600">
    <!-- Background Pattern -->
    <div class="absolute inset-0 bg-[url('https://grainy-gradients.vercel.app/noise.svg')] opacity-5 pointer-events-none"></div>
    <div class="absolute inset-0 bg-gradient-to-b from-slate-900/50 to-slate-950 pointer-events-none"></div>

    <div class="max-w-7xl mx-auto px-4 relative z-10">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-12 gap-8 lg:gap-12 mb-16">
            
            <!-- Column 1: Company Info (4 cols) -->
            <div class="lg:col-span-5 space-y-6">
                <a href="<?php echo e(route('home')); ?>" class="inline-block group">
                    <?php if($siteSettings->logo_url): ?>
                        <img src="<?php echo e(asset($siteSettings->logo_url)); ?>?v=<?php echo e(time()); ?>" alt="<?php echo e($siteSettings->site_title); ?>" class="h-20 w-auto brightness-0 invert opacity-90 group-hover:opacity-100 transition-all duration-300">
                    <?php else: ?>
                        <span class="text-3xl font-black tracking-tight text-white"><?php echo e($siteSettings->site_title); ?></span>
                    <?php endif; ?>
                </a>
                <p class="text-slate-400 leading-relaxed text-lg max-w-md font-medium">
                    <?php echo e(optional($companyInfo)->description ?? $siteSettings->site_description ?? 'شريكك الموثوق للنقل التجاري في مصر. نقدم أفضل حلول النقل من تاتا موتورز.'); ?>

                </p>
                
                <!-- Social Links -->
                <div class="flex items-center gap-4 pt-4">
                    <?php $__currentLoopData = ['facebook', 'instagram', 'twitter', 'youtube']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php ($socialUrl = $siteSettings->social_links[$social] ?? null); ?>
                        <?php if(is_string($socialUrl) && str_starts_with(strtolower($socialUrl), 'https://')): ?>
                            <a href="<?php echo e($socialUrl); ?>" target="_blank" rel="noopener noreferrer nofollow" class="w-12 h-12 rounded-full bg-slate-800 border border-slate-700 flex items-center justify-center text-slate-400 hover:bg-red-600 hover:text-white hover:border-red-500 hover:scale-110 transition-all duration-300 group">
                                <?php if($social == 'facebook'): ?>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z"/></svg>
                                <?php elseif($social == 'instagram'): ?>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772 4.902 4.902 0 011.772-1.153c.636-.247 1.363-.416 2.427-.465C9.673 2.013 10.03 2 12.484 2h.231zm-5.85 4.613c-.327 0-.591.263-.591.59 0 .327.264.59.59.59h.09c.327 0 .59-.264.59-.59 0-.327-.263-.591-.59-.591h-.089zm5.85 1.751a5.85 5.85 0 100 11.7 5.85 5.85 0 000-11.7zm0 1.939a3.91 3.91 0 110 7.82 3.91 3.91 0 010-7.82z"/></svg>
                                <?php elseif($social == 'twitter'): ?>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84"/></svg>
                                <?php elseif($social == 'youtube'): ?>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M19.812 5.418c.861.23 1.538.907 1.768 1.768C21.998 8.746 22 12 22 12s0 3.255-.418 4.814a2.504 2.504 0 0 1-1.768 1.768c-1.56.419-7.814.419-7.814.419s-6.255 0-7.814-.419a2.505 2.505 0 0 1-1.768-1.768C2 15.255 2 12 2 12s0-3.254.418-4.814a2.503 2.503 0 0 1 1.768-1.768C5.744 5 12 5 12 5s6.256 0 7.812.418zM15.194 12 10 15V9l5.194 3z"/></svg>
                                <?php endif; ?>
                            </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Column 2: Quick Links (2 cols) -->
            <div class="lg:col-span-2">
                <h3 class="text-white font-bold mb-6 text-lg relative inline-block">
                    روابط سريعة
                    <span class="absolute bottom-[-8px] right-0 w-8 h-1 bg-red-600 rounded-full"></span>
                </h3>
                <ul class="space-y-4">
                    <li><a href="<?php echo e(route('home')); ?>" class="text-slate-400 hover:text-white hover:translate-x-[-4px] transition-all inline-block font-medium">الرئيسية</a></li>
                    <li><a href="<?php echo e(route('vehicles.index')); ?>" class="text-slate-400 hover:text-white hover:translate-x-[-4px] transition-all inline-block font-medium">السيارات</a></li>
                    <li><a href="<?php echo e(route('services.index')); ?>" class="text-slate-400 hover:text-white hover:translate-x-[-4px] transition-all inline-block font-medium">خدماتنا</a></li>
                    <li><a href="<?php echo e(route('contact')); ?>" class="text-slate-400 hover:text-white hover:translate-x-[-4px] transition-all inline-block font-medium">اتصل بنا</a></li>
                </ul>
            </div>

            <!-- Column 3: Latest Vehicles (2 cols) -->
            <div class="lg:col-span-2">
                 <h3 class="text-white font-bold mb-6 text-lg relative inline-block">
                    أحدث الموديلات
                    <span class="absolute bottom-[-8px] right-0 w-8 h-1 bg-red-600 rounded-full"></span>
                </h3>
                 <ul class="space-y-4">
                    <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('vehicles.show', $vehicle->id)); ?>" class="text-slate-400 hover:text-red-500 hover:translate-x-[-4px] transition-all inline-block font-medium clamp-1"><?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 </ul>
            </div>

            <!-- Column 4: Contact Info (3 cols) -->
            <div class="lg:col-span-3">
                 <h3 class="text-white font-bold mb-6 text-lg relative inline-block">
                    تواصل معنا
                    <span class="absolute bottom-[-8px] right-0 w-8 h-1 bg-red-600 rounded-full"></span>
                </h3>
                 <ul class="space-y-5">
                    <?php if($siteSettings->contact_phone): ?>
                        <li class="flex items-start gap-4 group">
                            <span class="w-10 h-10 rounded-xl bg-slate-800 flex items-center justify-center text-red-500 group-hover:bg-red-600 group-hover:text-white transition-colors shrink-0">
                                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" /></svg>
                            </span>
                            <div>
                                <p class="text-xs text-slate-500 mb-1">اتصل بنا</p>
                                <span dir="ltr" class="text-white font-bold text-lg group-hover:text-red-500 transition-colors"><?php echo e($siteSettings->contact_phone); ?></span>
                            </div>
                        </li>
                    <?php endif; ?>
                    <?php if($siteSettings->contact_address): ?>
                        <li class="flex items-start gap-4 group">
                             <span class="w-10 h-10 rounded-xl bg-slate-800 flex items-center justify-center text-red-500 group-hover:bg-red-600 group-hover:text-white transition-colors shrink-0">
                                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                            </span>
                            <div>
                                <p class="text-xs text-slate-500 mb-1">الموقع</p>
                                <span class="text-slate-300 font-medium group-hover:text-white transition-colors"><?php echo e($siteSettings->contact_address); ?></span>
                            </div>
                        </li>
                    <?php endif; ?>
                 </ul>
            </div>
        </div>

        <div class="border-t border-slate-800 pt-8 mt-8 flex flex-col md:flex-row justify-between items-center gap-6">
            <p class="text-slate-500 text-sm font-medium dir-ltr">
                © <?php echo e(date('Y')); ?> <span class="text-white"><?php echo e($siteSettings->site_title); ?></span>. All rights reserved.
            </p>
            <div class="flex gap-8 text-sm text-slate-500 font-medium">
                <a href="<?php echo e(route('privacy')); ?>" class="hover:text-red-500 transition-colors">سياسة الخصوصية</a>
                <a href="<?php echo e(route('terms')); ?>" class="hover:text-red-500 transition-colors">الشروط والأحكام</a>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH C:\Users\shoko\OneDrive\Desktop\Elhamd-main\Elhamd-Laravel\resources\views/components/public-footer.blade.php ENDPATH**/ ?>