<?php
    $navigation = [
        ['label' => 'الرئيسية', 'href' => route('home'), 'active' => request()->routeIs('home'), 'icon' => 'car'],
        ['label' => 'السيارات', 'href' => route('vehicles.index'), 'active' => request()->routeIs('vehicles.*'), 'icon' => 'car'],
        ['label' => 'قيادة تجريبية', 'href' => route('public.test-drive'), 'active' => request()->routeIs('public.test-drive'), 'icon' => 'calendar'],
        ['label' => 'حجز خدمة', 'href' => route('public.service-booking'), 'active' => request()->routeIs('public.service-booking'), 'icon' => 'wrench'],
        ['label' => 'استشارة', 'href' => route('contact'), 'active' => request()->routeIs('contact'), 'icon' => 'phone'],
        ['label' => 'اتصل بنا', 'href' => route('contact'), 'active' => request()->routeIs('contact'), 'icon' => 'phone'],
    ];
    // Filter out duplicates if needed, or adjust structure
    $uniqueNav = [];
    $seen = [];
    foreach ($navigation as $item) {
        if (!in_array($item['label'], $seen)) {
            $uniqueNav[] = $item;
            $seen[] = $item['label'];
        }
    }
    $navigation = $uniqueNav;

    $logoUrl = $siteSettings->logo_url ?? '/uploads/logo/elhamd-logo.png';
    $siteTitle = $siteSettings->site_title ?? config('app.name');
?>

<nav x-data="{ mobileMenuOpen: false, scrolled: false }"
     @scroll.window="scrolled = (window.pageYOffset > 24)"
     class="fixed top-0 left-0 right-0 z-50 transition-all duration-500 border-b border-transparent"
     :class="{
        'bg-white/95 border-slate-200/70 text-slate-900 shadow-md backdrop-blur-xl py-2': scrolled || mobileMenuOpen || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?>,
        'bg-transparent border-transparent text-white shadow-none py-4': !scrolled && !mobileMenuOpen && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>

     }">
    <div class="max-w-7xl mx-auto px-4">
        <div class="flex justify-between items-center h-16 transition-all duration-300">
            <!-- Logo -->
            <div class="flex items-center">
                <a href="<?php echo e(route('home')); ?>" class="group flex items-center gap-3 rounded-xl px-2 py-1 transition hover:scale-[1.02]">
                    <?php if($logoUrl): ?>
                        <img src="<?php echo e(asset($logoUrl)); ?>?v=<?php echo e(time()); ?>"
                             alt="<?php echo e($siteTitle); ?>"
                             class="h-12 w-auto max-h-16 shrink-0 object-contain transition-transform duration-300 group-hover:scale-105"
                             onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                        <div style="display:none;">
                            <svg class="h-10 w-10 text-red-600" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"/><circle cx="7" cy="17" r="2"/><path d="M9 17h6"/><circle cx="17" cy="17" r="2"/></svg>
                        </div>
                    <?php else: ?>
                        <!-- Fallback SVG -->
                    <?php endif; ?>

                    <span class="text-xl md:text-2xl font-bold tracking-tight transition-colors hidden sm:block"
                          :class="{
                            'text-white drop-shadow-md': !scrolled && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>,
                            'text-slate-900': scrolled || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?>

                          }">
                        <?php echo e($siteTitle); ?>

                    </span>
                </a>
            </div>

            <!-- Desktop Navigation -->
            <div class="hidden md:flex items-center space-x-1 lg:space-x-4 space-x-reverse whitespace-nowrap">
                <?php $__currentLoopData = $navigation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($item['href']); ?>"
                       class="relative flex items-center space-x-1 space-x-reverse text-xs lg:text-sm font-bold transition-all px-2 lg:px-3 py-2 rounded-lg group whitespace-nowrap"
                       :class="{
                           'text-white drop-shadow-sm hover:bg-white/10': !<?php echo e($item['active'] ? 'true' : 'false'); ?> && !scrolled && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>,
                           'text-red-400 bg-white/10': <?php echo e($item['active'] ? 'true' : 'false'); ?> && !scrolled && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>,
                           'text-slate-600 hover:text-red-600 hover:bg-slate-50': !<?php echo e($item['active'] ? 'true' : 'false'); ?> && (scrolled || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?>),
                           'text-red-600 bg-red-50': <?php echo e($item['active'] ? 'true' : 'false'); ?> && (scrolled || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?>)
                       }">
                        <?php if($item['icon'] == 'car'): ?>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"/><circle cx="7" cy="17" r="2"/><path d="M9 17h6"/><circle cx="17" cy="17" r="2"/></svg>
                        <?php elseif($item['icon'] == 'search'): ?>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/></svg>
                        <?php elseif($item['icon'] == 'calendar'): ?>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect width="18" height="18" x="3" y="4" rx="2" ry="2"/><line x1="16" x2="16" y1="2" y2="6"/><line x1="8" x2="8" y1="2" y2="6"/><line x1="3" x2="21" y1="10" y2="10"/></svg>
                        <?php elseif($item['icon'] == 'wrench'): ?>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.7 6.3a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0l3.77-3.77a6 6 0 0 1-7.94 7.94l-6.91 6.91a2.12 2.12 0 0 1-3-3l6.91-6.91a6 6 0 0 1 7.94-7.94l-3.76 3.76z"/></svg>
                        <?php elseif($item['icon'] == 'phone'): ?>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/></svg>
                        <?php endif; ?>
                        <span><?php echo e($item['label']); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Contact Info (Large Screens) -->
            <div class="hidden lg:flex items-center space-x-4 space-x-reverse text-sm font-medium" 
                 :class="{ 'text-white/90': !scrolled && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>, 'text-slate-600': scrolled || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?> }">
                <?php if($siteSettings->contact_phone): ?>
                    <div class="flex items-center space-x-1 space-x-reverse">
                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/></svg>
                        <span dir="ltr"><?php echo e($siteSettings->contact_phone); ?></span>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Auth Buttons -->
            <div class="hidden md:flex items-center space-x-3 space-x-reverse">
                <?php if(auth()->guard()->check()): ?>
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" class="h-10 w-10 rounded-full bg-slate-100 border border-slate-200 flex items-center justify-center text-slate-700 font-bold focus:outline-none hover:bg-white transition-colors">
                            <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                        </button>
                        <div x-show="open" @click.away="open = false" class="absolute left-0 mt-3 w-56 bg-white rounded-xl shadow-xl py-2 ring-1 ring-black/5 origin-top-left" style="display: none;"
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="transform opacity-0 scale-95 translate-y-2"
                             x-transition:enter-end="transform opacity-100 scale-100 translate-y-0"
                             x-transition:leave="transition ease-in duration-150"
                             x-transition:leave-start="transform opacity-100 scale-100 translate-y-0"
                             x-transition:leave-end="transform opacity-0 scale-95 translate-y-2">
                            
                            <div class="flex flex-col space-y-1 px-4 py-3 border-b border-slate-100 bg-slate-50/50">
                                <p class="text-sm font-bold text-slate-900 leading-none"><?php echo e(Auth::user()->name); ?></p>
                                <p class="text-xs leading-none text-slate-500 mt-1"><?php echo e(Auth::user()->email); ?></p>
                            </div>

                            <div class="p-1">
                                <a href="<?php echo e(route('profile.edit')); ?>" class="flex items-center px-4 py-2 text-sm text-slate-700 hover:bg-slate-50 hover:text-red-600 rounded-lg transition-colors">
                                    <svg class="ml-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>
                                    <span>الملف الشخصي</span>
                                </a>
                                
                                <?php if(Auth::user()->isAdmin()): ?>
                                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center px-4 py-2 text-sm text-slate-700 hover:bg-slate-50 hover:text-red-600 rounded-lg transition-colors">
                                        <svg class="ml-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12.22 2h-.44a2 2 0 0 0-2 2v.18a2 2 0 0 1-1 1.73l-.43.25a2 2 0 0 1-2 0l-.15-.08a2 2 0 0 0-2.73.73l-.22.38a2 2 0 0 0 .73 2.73l.15.1a2 2 0 0 1 1 1.72v.51a2 2 0 0 1-1 1.74l-.15.09a2 2 0 0 0-.73 2.73l.22.38a2 2 0 0 0 2.73.73l.15-.08a2 2 0 0 1 2 0l.43.25a2 2 0 0 1 1 1.73V20a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.18a2 2 0 0 1 1-1.73l.43-.25a2 2 0 0 1 2 0l.15.08a2 2 0 0 0 2.73-.73l.22-.38a2 2 0 0 0-.73-2.73l-.15-.1a2 2 0 0 1-1-1.72v-.51a2 2 0 0 1 1-1.74l.15-.09a2 2 0 0 0 .73-2.73l-.22-.38a2 2 0 0 0-2.73-.73l-.15.08a2 2 0 0 1-2 0l-.43-.25a2 2 0 0 1-1-1.73V4a2 2 0 0 0-2-2z"/><circle cx="12" cy="12" r="3"/></svg>
                                        <span>لوحة التحكم</span>
                                    </a>
                                <?php elseif(Auth::user()->role === 'STAFF'): ?>
                                    <a href="<?php echo e(route('employee.dashboard')); ?>" class="flex items-center px-4 py-2 text-sm text-slate-700 hover:bg-slate-50 hover:text-red-600 rounded-lg transition-colors">
                                        <svg class="ml-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12.22 2h-.44a2 2 0 0 0-2 2v.18a2 2 0 0 1-1 1.73l-.43.25a2 2 0 0 1-2 0l-.15-.08a2 2 0 0 0-2.73.73l-.22.38a2 2 0 0 0 .73 2.73l.15.1a2 2 0 0 1 1 1.72v.51a2 2 0 0 1-1 1.74l-.15.09a2 2 0 0 0-.73 2.73l.22.38a2 2 0 0 0 2.73.73l.15-.08a2 2 0 0 1 2 0l.43.25a2 2 0 0 1 1 1.73V20a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.18a2 2 0 0 1 1-1.73l.43-.25a2 2 0 0 1 2 0l.15.08a2 2 0 0 0 2.73-.73l.22-.38a2 2 0 0 0-.73-2.73l-.15-.1a2 2 0 0 1-1-1.72v-.51a2 2 0 0 1 1-1.74l.15-.09a2 2 0 0 0 .73-2.73l-.22-.38a2 2 0 0 0-2.73-.73l-.15.08a2 2 0 0 1-2 0l-.43-.25a2 2 0 0 1-1-1.73V4a2 2 0 0 0-2-2z"/><circle cx="12" cy="12" r="3"/></svg>
                                        <span>لوحة الموظفين</span>
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('customer.dashboard')); ?>" class="flex items-center px-4 py-2 text-sm text-slate-700 hover:bg-slate-50 hover:text-red-600 rounded-lg transition-colors">
                                        <svg class="ml-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12.22 2h-.44a2 2 0 0 0-2 2v.18a2 2 0 0 1-1 1.73l-.43.25a2 2 0 0 1-2 0l-.15-.08a2 2 0 0 0-2.73.73l-.22.38a2 2 0 0 0 .73 2.73l.15.1a2 2 0 0 1 1 1.72v.51a2 2 0 0 1-1 1.74l-.15.09a2 2 0 0 0-.73 2.73l.22.38a2 2 0 0 0 2.73.73l.15-.08a2 2 0 0 1 2 0l.43.25a2 2 0 0 1 1 1.73V20a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.18a2 2 0 0 1 1-1.73l.43-.25a2 2 0 0 1 2 0l.15.08a2 2 0 0 0 2.73-.73l.22-.38a2 2 0 0 0-.73-2.73l-.15-.1a2 2 0 0 1-1-1.72v-.51a2 2 0 0 1 1-1.74l.15-.09a2 2 0 0 0 .73-2.73l-.22-.38a2 2 0 0 0-2.73-.73l-.15.08a2 2 0 0 1-2 0l-.43-.25a2 2 0 0 1-1-1.73V4a2 2 0 0 0-2-2z"/><circle cx="12" cy="12" r="3"/></svg>
                                        <span>لوحة العميل</span>
                                    </a>
                                <?php endif; ?>

                                <div class="border-t border-slate-100 my-1"></div>
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="flex items-center w-full text-right px-4 py-2 text-sm text-red-600 hover:bg-red-50 rounded-lg font-medium transition-colors">
                                        <svg class="ml-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/><polyline points="16 17 21 12 16 7"/><line x1="21" x2="9" y1="12" y2="12"/></svg>
                                        <span>تسجيل الخروج</span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="flex items-center space-x-2 space-x-reverse">
                        <a href="<?php echo e(route('login')); ?>" class="text-sm px-4 py-2.5 font-bold transition-all hover:text-white rounded-lg"
                        :class="{ 'text-white hover:bg-white/10': !scrolled && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>, 'text-slate-700 hover:bg-slate-100': scrolled || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?> }">
                            تسجيل الدخول
                        </a>
                        <a href="<?php echo e(route('register')); ?>" class="px-5 py-2.5 rounded-lg text-sm font-bold shadow-sm transition-all hover:shadow-md transform hover:-translate-y-0.5"
                        :class="{ 'bg-white text-slate-900': !scrolled && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>, 'bg-red-600 text-white hover:bg-red-700': scrolled || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?> }">
                            إنشاء حساب
                        </a>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Mobile Menu Button -->
            <div class="md:hidden">
                <button @click="mobileMenuOpen = !mobileMenuOpen" class="p-2.5 rounded-lg focus:outline-none transition-colors"
                    :class="{ 'text-white hover:bg-white/10': !scrolled && <?php echo e(request()->routeIs('home') ? 'true' : 'false'); ?>, 'text-slate-900 hover:bg-slate-100': scrolled || <?php echo e(!request()->routeIs('home') ? 'true' : 'false'); ?> }">
                    <svg x-show="!mobileMenuOpen" class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="4" x2="20" y1="12" y2="12"/><line x1="4" x2="20" y1="6" y2="6"/><line x1="4" x2="20" y1="18" y2="18"/></svg>
                    <svg x-show="mobileMenuOpen" class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="display: none;"><path d="M18 6 6 18"/><path d="m6 6 12 12"/></svg>
                </button>
            </div>
        </div>

        <!-- Mobile Navigation -->
        <div x-show="mobileMenuOpen" class="md:hidden border-t border-slate-100 bg-white/95 backdrop-blur-xl text-slate-900 absolute top-20 left-0 right-0 shadow-xl" style="display: none;"
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 -translate-y-2"
             x-transition:enter-end="opacity-100 translate-y-0"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-100 translate-y-0"
             x-transition:leave-end="opacity-0 -translate-y-2">
            
            <div class="px-3 pt-3 pb-4 space-y-1">
                <?php $__currentLoopData = $navigation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($item['href']); ?>" class="flex items-center space-x-3 space-x-reverse px-4 py-3 rounded-xl text-base font-bold transition-colors"
                       :class="{ 'bg-red-50 text-red-600': <?php echo e($item['active'] ? 'true' : 'false'); ?>, 'text-slate-600 hover:bg-slate-50': !<?php echo e($item['active'] ? 'true' : 'false'); ?> }"
                       @click="mobileMenuOpen = false">
                        <?php if($item['icon'] == 'car'): ?>
                            <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"/><circle cx="7" cy="17" r="2"/><path d="M9 17h6"/><circle cx="17" cy="17" r="2"/></svg>
                        <?php elseif($item['icon'] == 'search'): ?>
                            <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/></svg>
                        <?php elseif($item['icon'] == 'calendar'): ?>
                            <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect width="18" height="18" x="3" y="4" rx="2" ry="2"/><line x1="16" x2="16" y1="2" y2="6"/><line x1="8" x2="8" y1="2" y2="6"/><line x1="3" x2="21" y1="10" y2="10"/></svg>
                        <?php elseif($item['icon'] == 'wrench'): ?>
                            <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.7 6.3a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0l3.77-3.77a6 6 0 0 1-7.94 7.94l-6.91 6.91a2.12 2.12 0 0 1-3-3l6.91-6.91a6 6 0 0 1 7.94-7.94l-3.76 3.76z"/></svg>
                        <?php elseif($item['icon'] == 'phone'): ?>
                            <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/></svg>
                        <?php endif; ?>
                        <span><?php echo e($item['label']); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Contact Info Mobile -->
                <div class="border-t border-slate-100 pt-4 mt-4">
                    <div class="px-4 py-2 text-xs text-slate-400 uppercase font-bold tracking-wider">معلومات الاتصال</div>
                    <div class="px-4 py-2 space-y-3">
                        <?php if($siteSettings->contact_phone): ?>
                            <div class="flex items-center space-x-3 space-x-reverse text-sm font-medium text-slate-700">
                                <span class="w-8 h-8 rounded-full bg-slate-100 flex items-center justify-center text-slate-500">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/></svg>
                                </span>
                                <span dir="ltr"><?php echo e($siteSettings->contact_phone); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if($siteSettings->contact_email): ?>
                            <div class="flex items-center space-x-3 space-x-reverse text-sm font-medium text-slate-700">
                                <span class="w-8 h-8 rounded-full bg-slate-100 flex items-center justify-center text-slate-500">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect width="20" height="16" x="2" y="4" rx="2"/><path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"/></svg>
                                </span>
                                <span><?php echo e($siteSettings->contact_email); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Auth Mobile -->
                <div class="border-t border-slate-100 pt-4 mt-4 px-4 pb-2">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="space-y-3">
                             <div class="flex items-center space-x-3 space-x-reverse p-3 bg-slate-50 rounded-xl">
                                <div class="h-10 w-10 rounded-full bg-white shadow-sm flex items-center justify-center text-red-600 font-bold text-lg border border-slate-100">
                                    <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                                </div>
                                <div>
                                    <p class="text-sm font-bold text-slate-900"><?php echo e(Auth::user()->name); ?></p>
                                    <p class="text-xs text-slate-500"><?php echo e(Auth::user()->email); ?></p>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 gap-2">
                                <a href="<?php echo e(route('profile.edit')); ?>" class="flex items-center justify-center gap-2 px-4 py-3 rounded-xl bg-white border border-slate-200 text-sm font-bold text-slate-700">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>
                                    <span>الملف الشخصي</span>
                                </a>
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="flex items-center justify-center gap-2 w-full px-4 py-3 rounded-xl bg-red-50 text-sm font-bold text-red-600">
                                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/><polyline points="16 17 21 12 16 7"/><line x1="21" x2="9" y1="12" y2="12"/></svg>
                                        <span>تسجيل الخروج</span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="grid grid-cols-2 gap-3">
                            <a href="<?php echo e(route('login')); ?>" class="w-full text-center px-4 py-3 text-sm font-bold text-slate-700 bg-white border border-slate-200 rounded-xl" @click="mobileMenuOpen = false">
                                تسجيل الدخول
                            </a>
                            <a href="<?php echo e(route('register')); ?>" class="w-full text-center bg-red-600 text-white hover:bg-red-700 px-4 py-3 rounded-xl text-sm font-bold" @click="mobileMenuOpen = false">
                                إنشاء حساب
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH C:\Users\shoko\OneDrive\Desktop\Elhamd-main\Elhamd-Laravel\resources\views/components/public-navbar.blade.php ENDPATH**/ ?>