<?php if (isset($component)) { $__componentOriginal42b37f006f8ebbe12b66cfa27a5def06 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06 = $attributes; } ?>
<?php $component = App\View\Components\PublicLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('public-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PublicLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="min-h-screen bg-slate-50 pb-20" x-data="testDriveBooking()">
        <!-- Page Header -->
        <div class="bg-white border-b border-gray-200">
            <div class="container mx-auto px-4 py-8 md:py-12">
                <div class="text-center">
                    <h1 class="text-3xl md:text-4xl font-bold mb-4 text-[#0A1A3F]">حجز تجربة قيادة</h1>
                    <p class="text-lg md:text-xl text-gray-600">
                        جرب بنفسك سيارتك المفضلة من تاتا
                    </p>
                </div>
            </div>
        </div>

        <div class="container mx-auto px-4 py-8">
            <div class="max-w-4xl mx-auto">
                <!-- Progress Steps -->
                <div x-show="!submitSuccess" class="mb-6 sm:mb-8">
                    <div class="flex items-center justify-center flex-wrap gap-2 sm:gap-0">
                        <template x-for="stepNumber in [1, 2, 3, 4, 5]" :key="stepNumber">
                            <div class="flex items-center">
                                <div class="w-8 h-8 rounded-full flex items-center justify-center text-sm font-medium transition-colors"
                                     :class="step >= stepNumber ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-600'">
                                    <span x-text="stepNumber"></span>
                                </div>
                                <span class="ml-1 sm:ml-2 text-xs sm:text-sm font-medium"
                                      :class="step >= stepNumber ? 'text-blue-600' : 'text-gray-500'">
                                    <span x-show="stepNumber === 1">المركبة</span>
                                    <span x-show="stepNumber === 2">التاريخ</span>
                                    <span x-show="stepNumber === 3">الوقت</span>
                                    <span x-show="stepNumber === 4">التفاصيل</span>
                                    <span x-show="stepNumber === 5">تأكيد</span>
                                </span>
                                <template x-if="stepNumber < 5">
                                    <div class="w-8 sm:w-16 h-1 mx-1 sm:mx-4 transition-colors"
                                         :class="step > stepNumber ? 'bg-blue-600' : 'bg-gray-200'"></div>
                                </template>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- Success Message -->
                <div x-show="submitSuccess" style="display: none;">
                    <div class="bg-white rounded-xl shadow-lg p-8 text-center">
                        <div class="flex justify-center mb-6">
                            <svg class="h-16 w-16 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                        </div>
                        <h2 class="text-2xl font-bold mb-4 text-[#0A1A3F]">تم حجز تجربة القيادة بنجاح!</h2>
                        <p class="text-gray-600 mb-6">
                            شكراً لحجزك تجربة قيادة مع شركة الحمد للسيارات. سنقوم بتأكيد موعدك قريباً.
                        </p>
                        <div class="bg-gray-50 rounded-lg p-6 mb-6 text-right max-w-md mx-auto">
                            <h3 class="font-semibold mb-2 text-[#0A1A3F]">تفاصيل الحجز:</h3>
                            <p><strong>المركبة:</strong> <span x-text="selectedVehicleName"></span></p>
                            <p><strong>التاريخ:</strong> <span x-text="formData.date"></span></p>
                            <p><strong>الوقت:</strong> <span x-text="formData.timeSlot"></span></p>
                            <p><strong>الاسم:</strong> <span x-text="formData.customerInfo.name"></span></p>
                        </div>
                        <button @click="resetForm()" class="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700">
                            حجز تجربة قيادة أخرى
                        </button>
                    </div>
                </div>

                <!-- Step 1: Vehicle Selection -->
                <div x-show="step === 1 && !submitSuccess">
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <h2 class="text-2xl font-bold mb-6 text-[#0A1A3F]">اختر مركبة</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div @click="selectVehicle(<?php echo e($vehicle); ?>)"
                                     class="cursor-pointer border-2 rounded-xl p-4 transition-all hover:shadow-md group"
                                     :class="formData.vehicleId == '<?php echo e($vehicle->id); ?>' ? 'border-blue-500 bg-blue-50/10' : 'border-gray-100 hover:border-blue-200'">
                                    
                                    
                                    <div class="h-40 bg-gray-200 rounded-lg mb-4 overflow-hidden relative">
                                        <?php if($vehicle->images && $vehicle->images->count() > 0): ?>
                                            <img src="<?php echo e($vehicle->images->first()->image_url); ?>" alt="<?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                                        <?php else: ?>
                                            <div class="flex items-center justify-center h-full text-gray-400">
                                                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                            </div>
                                        <?php endif; ?>
                                        <div class="absolute inset-0 bg-black/10 group-hover:bg-transparent transition-colors"></div>
                                    </div>
                                    
                                    <h3 class="font-bold text-lg text-gray-900"><?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?></h3>
                                    <p class="text-sm text-gray-600 mb-2"><?php echo e($vehicle->year); ?></p>
                                    
                                    <div class="flex gap-2 mt-2">
                                        <span class="text-xs bg-gray-100 px-2 py-1 rounded text-gray-600"><?php echo e($vehicle->fuel_type ?? 'غير محدد'); ?></span>
                                        <span class="text-xs bg-gray-100 px-2 py-1 rounded text-gray-600"><?php echo e($vehicle->transmission ?? 'غير محدد'); ?></span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <!-- Step 2: Date Selection -->
                <div x-show="step === 2 && !submitSuccess" style="display: none;">
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <div class="flex items-center gap-4 mb-6">
                            <button @click="step = 1" class="p-2 hover:bg-gray-100 rounded-full">
                                <svg class="h-5 w-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                            </button>
                            <h2 class="text-2xl font-bold text-[#0A1A3F]">اختر التاريخ</h2>
                        </div>
                        
                        <div class="max-w-md mx-auto">
                            <label class="block text-sm font-medium text-gray-700 mb-2">التاريخ المفضل</label>
                            <input type="date" x-model="formData.date" class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 p-3"
                                   min="<?php echo e(date('Y-m-d')); ?>"
                                   @change="if(formData.date) step = 3">
                        </div>
                    </div>
                </div>

                <!-- Step 3: Time Selection -->
                <div x-show="step === 3 && !submitSuccess" style="display: none;">
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <div class="flex items-center gap-4 mb-6">
                            <button @click="step = 2" class="p-2 hover:bg-gray-100 rounded-full">
                                <svg class="h-5 w-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                            </button>
                            <h2 class="text-2xl font-bold text-[#0A1A3F]">اختر الوقت</h2>
                        </div>
                        
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <template x-for="time in ['09:00', '10:00', '11:00', '12:00', '13:00', '14:00', '15:00', '16:00']">
                                <button @click="selectTime(time)"
                                        class="py-3 px-4 rounded-lg border-2 text-center transition-all hover:border-blue-400 hover:bg-blue-50"
                                        :class="formData.timeSlot == time ? 'border-blue-600 bg-blue-100 text-blue-800 font-bold' : 'border-gray-200 text-gray-600'">
                                    <span x-text="time"></span>
                                </button>
                            </template>
                        </div>
                    </div>
                </div>

                <!-- Step 4: Details & Confirmation -->
                <div x-show="step === 4 && !submitSuccess" style="display: none;">
                    <div class="space-y-6">
                         <div class="flex items-center gap-4 mb-6 bg-white p-4 rounded-xl shadow-sm">
                            <button @click="step = 3" class="p-2 hover:bg-gray-100 rounded-full">
                                <svg class="h-5 w-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
                            </button>
                            <h2 class="text-2xl font-bold text-[#0A1A3F]">معلوماتك وتأكيد الحجز</h2>
                        </div>

                        <div class="bg-white rounded-xl shadow-sm p-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">الاسم الكامل *</label>
                                    <input type="text" x-model="formData.customerInfo.name" class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">البريد الإلكتروني *</label>
                                    <input type="email" x-model="formData.customerInfo.email" class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">رقم الهاتف *</label>
                                    <input type="tel" x-model="formData.customerInfo.phone" class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">رقم رخصة القيادة *</label>
                                    <input type="text" x-model="formData.customerInfo.licenseNumber" class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                </div>
                                <div class="md:col-span-2">
                                     <label class="block text-sm font-medium text-gray-700 mb-1">ملاحظات إضافية</label>
                                     <textarea x-model="formData.message" rows="3" class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="bg-blue-50 border border-blue-100 rounded-xl p-6">
                            <h3 class="font-bold text-blue-900 mb-4 text-lg">ملخص الحجز</h3>
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm">
                                <div>
                                    <span class="block text-blue-500 mb-1">المركبة</span>
                                    <span class="font-semibold text-blue-900" x-text="selectedVehicleName"></span>
                                </div>
                                <div>
                                    <span class="block text-blue-500 mb-1">التاريخ</span>
                                    <span class="font-semibold text-blue-900" x-text="formData.date"></span>
                                </div>
                                <div>
                                    <span class="block text-blue-500 mb-1">الوقت</span>
                                    <span class="font-semibold text-blue-900" x-text="formData.timeSlot"></span>
                                </div>
                            </div>
                        </div>

                        <div class="flex gap-4">
                            <button @click="bookTestDrive()" 
                                    class="flex-1 bg-blue-600 text-white font-bold py-4 rounded-lg hover:bg-blue-700 hover:shadow-lg transition-all disabled:opacity-50"
                                    :disabled="loading || !formData.customerInfo.name || !formData.customerInfo.phone">
                                <span x-show="!loading">تأكيد الحجز</span>
                                <span x-show="loading">جاري المعالجة...</span>
                            </button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script>
        function testDriveBooking() {
            return {
                step: 1,
                loading: false,
                submitSuccess: false,
                selectedVehicleName: '',
                formData: {
                    vehicleId: '',
                    date: '',
                    timeSlot: '',
                    customerInfo: {
                        name: '<?php echo e(Auth::user()->name ?? ""); ?>',
                        email: '<?php echo e(Auth::user()->email ?? ""); ?>',
                        phone: '<?php echo e(Auth::user()->phone ?? ""); ?>',
                        licenseNumber: ''
                    },
                    message: ''
                },

                selectVehicle(vehicle) {
                    this.formData.vehicleId = vehicle.id;
                    this.selectedVehicleName = vehicle.make + ' ' + vehicle.model;
                    this.step = 2;
                },

                selectTime(time) {
                    this.formData.timeSlot = time;
                    this.step = 4;
                },

                bookTestDrive() {
                    this.loading = true;
                    // Simulate API call
                    setTimeout(() => {
                        this.loading = false;
                        this.submitSuccess = true;
                        this.step = 5;
                    }, 1500);

                    /* 
                    // Real implementation
                    fetch('/api/bookings/test-drive', {
                        method: 'POST',
                        body: JSON.stringify(this.formData),
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        }
                    })...
                    */
                },

                resetForm() {
                    this.step = 1;
                    this.submitSuccess = false;
                    this.formData.vehicleId = '';
                    this.formData.date = '';
                    this.formData.timeSlot = '';
                    this.formData.message = '';
                    this.selectedVehicleName = '';
                }
            }
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06)): ?>
<?php $attributes = $__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06; ?>
<?php unset($__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42b37f006f8ebbe12b66cfa27a5def06)): ?>
<?php $component = $__componentOriginal42b37f006f8ebbe12b66cfa27a5def06; ?>
<?php unset($__componentOriginal42b37f006f8ebbe12b66cfa27a5def06); ?>
<?php endif; ?>
<?php /**PATH C:\Users\shoko\OneDrive\Desktop\Elhamd-main\Elhamd-Laravel\resources\views/public/test-drive.blade.php ENDPATH**/ ?>