<?php if (isset($component)) { $__componentOriginal42b37f006f8ebbe12b66cfa27a5def06 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06 = $attributes; } ?>
<?php $component = App\View\Components\PublicLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('public-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PublicLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', 'الرئيسية'); ?>

    <!-- Hero Slider -->
    <div class="relative w-full overflow-hidden" dir="ltr">
        <div class="swiper main-slider h-[90vh]">
            <div class="swiper-wrapper">
                <?php $__empty_1 = true; $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="swiper-slide relative">
                        <!-- Background Image -->
                        <div class="absolute inset-0">
                            <img src="<?php echo e($slider->image_url); ?>" alt="<?php echo e($slider->title); ?>" class="w-full h-full object-cover transform scale-105 transition-transform duration-[10000ms] hover:scale-100">
                            <div class="absolute inset-0 bg-gradient-to-r from-black/80 via-black/50 to-transparent"></div>
                            <div class="absolute inset-0 bg-gradient-to-t from-[#0A1A3F] via-transparent to-transparent opacity-90"></div>
                        </div>
                        
                        <!-- Content -->
                        <div class="relative z-10 h-full flex items-center">
                            <div class="container mx-auto px-4 md:px-8">
                                <div class="max-w-4xl <?php echo e($slider->text_position === 'left' ? 'mr-auto text-left' : ($slider->text_position === 'center' ? 'mx-auto text-center' : 'ml-auto text-right')); ?>" dir="rtl">
                                    <?php if($slider->badge_text): ?>
                                        <span data-aos="fade-down" data-aos-delay="200" class="inline-block py-2 px-4 mb-6 rounded-full bg-red-600/90 backdrop-blur-sm text-white text-sm font-bold tracking-wider shadow-lg border border-red-500/50">
                                            <?php echo e($slider->badge_text); ?>

                                        </span>
                                    <?php endif; ?>
                                    <h1 data-aos="fade-up" data-aos-delay="400" class="text-5xl md:text-7xl lg:text-8xl font-black text-white mb-6 leading-tight drop-shadow-2xl">
                                        <?php echo e($slider->title); ?>

                                    </h1>
                                    <p data-aos="fade-up" data-aos-delay="600" class="text-xl md:text-2xl text-gray-100 mb-10 leading-relaxed max-w-2xl <?php echo e($slider->text_position === 'center' ? 'mx-auto' : ''); ?> font-light">
                                        <?php echo e($slider->subtitle); ?>

                                    </p>
                                    <?php if($slider->btn_text): ?>
                                        <div data-aos="fade-up" data-aos-delay="800" class="flex flex-wrap gap-4 <?php echo e($slider->text_position === 'center' ? 'justify-center' : ''); ?>">
                                            <a href="<?php echo e($slider->btn_link); ?>" class="group relative overflow-hidden bg-red-600 text-white px-8 py-4 rounded-xl text-lg font-bold transition-all hover:scale-105 shadow-[0_0_20px_rgba(220,38,38,0.5)] hover:shadow-[0_0_30px_rgba(220,38,38,0.7)]">
                                                <div class="absolute inset-0 w-full h-full bg-gradient-to-r from-transparent via-white/20 to-transparent -translate-x-full group-hover:animate-shimmer"></div>
                                                <span class="flex items-center gap-3">
                                                    <?php echo e($slider->btn_text); ?>

                                                    <svg class="h-5 w-5 rtl:rotate-180 transition-transform group-hover:translate-x-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m9 18 6-6-6-6"/></svg>
                                                </span>
                                            </a>
                                            <a href="<?php echo e(route('public.service-booking')); ?>" class="px-8 py-4 rounded-xl text-lg font-bold text-white border-2 border-white/30 hover:bg-white/10 backdrop-blur-sm transition-all hover:border-white">
                                                حجز خدمة
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                     <div class="swiper-slide relative">
                        <div class="absolute inset-0 bg-[#0A1A3F]">
                             <div class="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/carbon-fibre.png')] opacity-20"></div>
                        </div>
                         <div class="relative z-10 h-full flex items-center justify-center text-center">
                             <div class="max-w-4xl px-4">
                                <h1 data-aos="zoom-in" class="text-6xl md:text-8xl font-black text-white mb-6 tracking-tight">الحمد للسيارات</h1>
                                <p data-aos="fade-up" data-aos-delay="300" class="text-2xl text-gray-300 font-light">الريادة في عالم السيارات والشاحنات التجارية</p>
                             </div>
                         </div>
                     </div>
                <?php endif; ?>
            </div>
            
            <!-- Navigation -->
            <div class="swiper-pagination !bottom-10"></div>
            <div class="swiper-button-next !text-white/50 hover:!text-white transition-colors !w-12 !h-12 !bg-black/20 hover:!bg-black/50 !rounded-full !backdrop-blur-sm"></div>
            <div class="swiper-button-prev !text-white/50 hover:!text-white transition-colors !w-12 !h-12 !bg-black/20 hover:!bg-black/50 !rounded-full !backdrop-blur-sm"></div>
        </div>
    </div>

    <!-- Company Intro Section -->
    <section class="py-24 md:py-32 bg-white relative overflow-hidden">
        <div class="max-w-7xl mx-auto px-4">
            <div class="flex flex-col lg:flex-row items-center gap-16 lg:gap-24">
                <!-- Data Side -->
                <div class="w-full lg:w-1/2 space-y-8" data-aos="fade-left">
                     <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-blue-50 text-blue-800 text-sm font-bold border border-blue-100 shadow-sm">
                        <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m12 8.5-6.5 9h13Z"/><path d="M12 2v6.5"/><path d="m18.5 17.5 3 3"/><path d="m2.5 17.5 3 3"/></svg>
                        من نحن
                    </span>
                    <h2 class="text-4xl md:text-6xl font-bold leading-tight text-gray-900">
                        <span class="text-transparent bg-clip-text bg-gradient-to-l from-blue-900 to-blue-600 block mb-2">شريكك الموثوق</span>
                        للنقل التجاري في مصر
                    </h2>
                    <p class="text-xl text-gray-600 leading-relaxed font-light">
                         <?php echo e($companyInfo->description ?? 'شركة الحمد لاستيراد السيارات هي الموزع المعتمد الرائد لمركبات تاتا موتورز التجارية في منطقة القناة وسيناء. نسعى دائماً لتقديم أفضل حلول النقل لعملائنا.'); ?>

                    </p>
                    
                    <ul class="space-y-6">
                        <?php $__currentLoopData = ['خبرة تمتد لأكثر من 20 عاماً', 'خدمة عملاء متميزة ودعم فني متواصل', 'قطع غيار أصلية وخدمة ما بعد البيع']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="flex items-start gap-4" data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>">
                            <div class="mt-1 flex-shrink-0 w-8 h-8 rounded-full bg-green-100 flex items-center justify-center shadow-sm">
                                <svg class="w-4 h-4 text-green-600" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 6 9 17l-5-5"/></svg>
                            </div>
                            <span class="text-gray-800 text-lg font-medium"><?php echo e($feature); ?></span>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                    <div class="pt-8 flex flex-wrap gap-4">
                        <a href="<?php echo e(route('vehicles.index')); ?>" class="inline-flex items-center justify-center px-8 py-4 border border-transparent text-lg font-bold rounded-xl text-white bg-[#0A1A3F] hover:bg-blue-900 transition shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                            تصفح السيارات
                        </a>
                        <a href="<?php echo e(route('contact')); ?>" class="inline-flex items-center justify-center px-8 py-4 border-2 border-gray-200 text-lg font-bold rounded-xl text-gray-700 bg-white hover:bg-gray-50 hover:border-blue-300 transition">
                            تواصل معنا
                        </a>
                    </div>
                </div>

                <!-- Visual Side -->
                <div class="w-full lg:w-1/2 relative" data-aos="fade-right" data-aos-delay="200">
                    <div class="absolute -top-20 -right-20 w-80 h-80 bg-blue-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-pulse"></div>
                    <div class="absolute -bottom-20 -left-20 w-80 h-80 bg-red-100 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-pulse animation-delay-2000"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl border-[6px] border-white transform rotate-2 hover:rotate-0 transition-transform duration-700 group">
                         <img src="/assets/images/about-hero.jpg" alt="About Us" class="w-full h-auto object-cover transform scale-100 group-hover:scale-105 transition-transform duration-700" 
                              onerror="this.src='https://placehold.co/800x600/0A1A3F/FFF?text=Elhamd+Auto'">
                         <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <?php if(count($services) > 0): ?>
    <section class="py-24 md:py-32 bg-gray-50 relative">
        <div class="absolute top-0 left-0 w-full h-px bg-gradient-to-r from-transparent via-gray-300 to-transparent"></div>
        <div class="max-w-7xl mx-auto px-4">
            <div class="text-center mb-20">
                <span data-aos="fade-up" class="inline-flex items-center gap-2 px-4 py-2 mb-6 rounded-full bg-red-50 text-red-600 text-sm font-bold border border-red-100">
                   <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.7 6.3a1 1 0 0 0 0 1.4l1.6 1.6a1 1 0 0 0 1.4 0l3.77-3.77a6 6 0 0 1-7.94 7.94l-6.91 6.91a2.12 2.12 0 0 1-3-3l6.91-6.91a6 6 0 0 1 7.94-7.94l-3.76 3.76z"/></svg>
                   خدماتنا
                </span>
                <h2 data-aos="fade-up" data-aos-delay="100" class="text-4xl md:text-6xl font-black mb-8 text-gray-900">
                    خدماتنا المتكاملة
                </h2>
                <p data-aos="fade-up" data-aos-delay="200" class="text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">
                    نقدم مجموعة شاملة من الخدمات لضمان أفضل تجربة لعملائنا، من الصيانة الدورية إلى توفير قطع الغيار الأصلية.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>" class="group bg-white p-10 rounded-3xl shadow-sm hover:shadow-2xl transition-all duration-300 border border-gray-100 hover:border-red-100 hover:-translate-y-2 relative overflow-hidden">
                        <div class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-br from-gray-50 to-white rounded-bl-full -mr-4 -mt-4 transition-transform group-hover:scale-150 group-hover:bg-red-50 z-0"></div>
                        
                        <div class="relative z-10 w-20 h-20 rounded-2xl flex items-center justify-center mb-8 bg-[#0A1A3F] text-white shadow-lg group-hover:scale-110 transition-transform duration-300">
                             <svg class="h-10 w-10" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/></svg>
                        </div>
                        <h3 class="relative z-10 text-2xl font-bold text-gray-900 mb-4 group-hover:text-red-600 transition-colors">
                            <?php echo e($service->title); ?>

                        </h3>
                        <p class="relative z-10 text-gray-600 leading-relaxed mb-6">
                            <?php echo e(Str::limit($service->description, 100)); ?>

                        </p>
                         <div class="relative z-10 pt-4 border-t border-gray-100">
                            <a href="<?php echo e(route('public.service-booking')); ?>" class="inline-flex items-center text-blue-900 font-bold hover:text-red-600 transition-colors group-hover:gap-2">
                                احجز الآن
                                <svg class="w-5 h-5 mr-2 rtl:rotate-180" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Vehicles Section -->
    <section class="py-24 md:py-32 bg-white relative w-full overflow-hidden">
        <!-- Background Decoration -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute top-1/2 -right-64 w-[800px] h-[800px] rounded-full opacity-5 blur-3xl bg-blue-900"></div>
            <div class="absolute bottom-0 -left-64 w-[600px] h-[600px] rounded-full opacity-5 blur-3xl bg-red-900"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 relative z-10">
            <div class="flex flex-col md:flex-row justify-between items-end mb-16 gap-6">
                <div class="max-w-2xl">
                    <span data-aos="fade-right" class="inline-flex items-center gap-2 px-4 py-2 mb-6 rounded-full bg-blue-50 text-blue-900 text-sm font-bold border border-blue-100">
                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"/><circle cx="7" cy="17" r="2"/><path d="M9 17h6"/><circle cx="17" cy="17" r="2"/></svg>
                        أسطولنا
                    </span>
                    <h2 data-aos="fade-up" class="text-4xl md:text-6xl font-black text-gray-900 mb-4">
                        استكشف أحدث الموديلات
                    </h2>
                    <p data-aos="fade-up" data-aos-delay="100" class="text-xl text-gray-500 font-light">
                        مجموعة متنوعة من سيارات تاتا التجارية بأعلى المواصفات
                    </p>
                </div>
                <div data-aos="fade-left">
                     <a href="<?php echo e(route('vehicles.index')); ?>" class="inline-flex items-center justify-center px-8 py-4 border border-gray-200 text-lg font-bold rounded-full text-gray-700 bg-white hover:bg-gray-50 hover:border-black transition-all shadow-sm hover:shadow-md">
                        عرض جميع السيارات
                        <svg class="mr-3 h-5 w-5 rtl:rotate-180" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                    </a>
                </div>
            </div>

            <!-- Vehicles Grid -->
            <?php if($featuredVehicles->count() > 0): ?>
                <div class="grid gap-8 sm:grid-cols-2 lg:grid-cols-3">
                    <?php $__currentLoopData = $featuredVehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>" class="group flex flex-col overflow-hidden rounded-3xl border border-gray-100 bg-white shadow-lg transition-all duration-300 hover:-translate-y-2 hover:shadow-2xl hover:border-blue-100">
                            <div class="relative aspect-[4/3] w-full bg-gray-100 overflow-hidden">
                                <div class="absolute inset-0 bg-gray-200 animate-pulse"></div>
                                <img src="<?php echo e($vehicle->main_image_url); ?>" alt="<?php echo e($vehicle->name); ?>" class="relative h-full w-full object-cover transition-transform duration-700 group-hover:scale-110"
                                     onload="this.previousElementSibling.style.display='none'"
                                     onerror="this.src='/assets/images/placeholder-car.jpg'; this.previousElementSibling.style.display='none'">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-60"></div>
                                
                                <div class="absolute top-4 left-4 flex flex-col gap-2">
                                     <?php if($vehicle->year): ?>
                                        <span class="inline-flex items-center rounded-lg bg-white/95 backdrop-blur px-3 py-1.5 text-sm font-bold text-gray-900 shadow-lg">
                                            <?php echo e($vehicle->year); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="absolute bottom-4 right-4 text-white">
                                     <span class="inline-block px-3 py-1 rounded-lg bg-blue-600 text-xs font-bold uppercase tracking-wider shadow-md">
                                        <?php echo e($vehicle->category->name ?? 'تجاري'); ?>

                                    </span>
                                </div>
                            </div>
                            
                            <div class="flex flex-1 flex-col p-8">
                                <div class="mb-6">
                                    <h3 class="text-2xl font-bold text-gray-900 mb-2 group-hover:text-blue-900 transition-colors"><?php echo e($vehicle->name); ?></h3>
                                    <p class="text-gray-500 line-clamp-2 leading-relaxed"><?php echo e($vehicle->description); ?></p>
                                </div>
                                
                                <div class="grid grid-cols-2 gap-4 mb-8">
                                     <div class="flex items-center gap-3 p-3 rounded-xl bg-gray-50 group-hover:bg-blue-50 transition-colors">
                                        <svg class="h-5 w-5 text-gray-400 group-hover:text-blue-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 2v20"/><path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/></svg>
                                        <span class="text-sm font-medium text-gray-700"><?php echo e(__('vehicle.fuel_types.' . $vehicle->fuel_type)); ?></span>
                                    </div>
                                    <div class="flex items-center gap-3 p-3 rounded-xl bg-gray-50 group-hover:bg-blue-50 transition-colors">
                                        <svg class="h-5 w-5 text-gray-400 group-hover:text-blue-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M12 2a7 7 0 1 0 10 10"/></svg>
                                        <span class="text-sm font-medium text-gray-700"><?php echo e(__('vehicle.transmission_types.' . $vehicle->transmission_type)); ?></span>
                                    </div>
                                </div>

                                <div class="mt-auto flex items-center justify-between pt-6 border-t border-gray-100">
                                    <div class="flex flex-col">
                                        <span class="text-xs text-gray-400 font-medium">يبدأ من</span>
                                        <span class="text-2xl font-black text-blue-900 tracking-tight">
                                            <?php echo e(number_format($vehicle->price, 0)); ?> <span class="text-sm font-bold text-gray-500">ج.م</span>
                                        </span>
                                    </div>
                                    <a href="<?php echo e(route('vehicles.show', $vehicle->id)); ?>" class="rounded-xl bg-gray-900 px-6 py-3 text-sm font-bold text-white shadow-lg hover:bg-red-600 hover:shadow-red-500/30 transition-all transform hover:-translate-y-1">
                                        التفاصيل
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-20 bg-gray-50 rounded-3xl border-2 border-dashed border-gray-200">
                    <p class="text-gray-400 text-xl font-medium">لا توجد سيارات مميزة حالياً</p>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Stats Section -->
    <?php if(count($stats) > 0): ?>
    <section class="py-24 bg-[#0A1A3F] relative overflow-hidden">
        <div class="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')] opacity-10 animate-pulse"></div>
        <div class="absolute top-0 right-0 w-1/2 h-full bg-gradient-to-l from-white/5 to-transparent"></div>
        
        <div class="max-w-7xl mx-auto px-4 relative z-10">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-12 md:gap-16">
                <?php $__currentLoopData = $stats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="text-center group" data-aos="zoom-in" data-aos-delay="<?php echo e($index * 100); ?>">
                        <div class="text-5xl md:text-7xl font-black text-white mb-4 group-hover:scale-110 transition-transform duration-300 drop-shadow-[0_4px_10px_rgba(0,0,0,0.5)]">
                            <?php echo e($stat->value); ?>

                        </div>
                        <div class="text-blue-200 text-xl font-medium tracking-wide border-t border-blue-800/50 pt-4 inline-block px-8">
                            <?php echo e($stat->title); ?>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Tata Motors Section -->
    <section class="relative py-32 overflow-hidden h-[600px] flex items-center">
        <div class="absolute inset-0">
             <img src="/assets/images/tata-bg.jpg" class="w-full h-full object-cover fixed-bg" alt="Tata Motors" onerror="this.src='https://placehold.co/1920x800/1e293b/FFF?text=Tata+Motors+Background'">
             <div class="absolute inset-0 bg-gradient-to-r from-black/95 via-black/80 to-transparent"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 relative z-10 w-full">
            <div class="max-w-xl" data-aos="fade-right">
                <div class="mb-10 bg-white/10 backdrop-blur-md p-6 rounded-2xl inline-block border border-white/20">
                     <img src="/assets/images/tata-logo-white.png" alt="Tata Motors" class="h-16 opacity-100" onerror="this.style.display='none'">
                </div>
                <h2 class="text-5xl md:text-7xl font-black text-white mb-8 leading-tight">
                    قوة.. متانة.. <br> <span class="text-red-600">اعتمادية</span>
                </h2>
                <p class="text-xl text-gray-300 mb-10 leading-relaxed font-light border-l-4 border-red-600 pl-6">
                    بصفتنا الوكيل المعتمد لشركة تاتا موتورز، نضمن لك مركبات مصممة لتتحمل أصعب ظروف العمل مع توفير أقصى درجات الراحة والأمان.
                </p>
                <div class="flex gap-6">
                    <a href="<?php echo e(route('tata-motors')); ?>" class="px-8 py-4 bg-red-600 text-white font-bold rounded-xl shadow-lg hover:bg-red-700 transition transform hover:scale-105">
                        اكتشف تاتا موتورز
                    </a>
                    <a href="<?php echo e(route('public.test-drive')); ?>" class="px-8 py-4 bg-transparent border-2 border-white text-white font-bold rounded-xl hover:bg-white hover:text-black transition">
                        طلب قيادة تجريبية
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Values Section -->
    <?php if(count($values) > 0): ?>
    <section class="py-24 md:py-32 bg-white">
        <div class="max-w-7xl mx-auto px-4">
            <div class="text-center mb-20">
                 <span data-aos="fade-up" class="inline-flex items-center gap-2 px-4 py-2 mb-6 rounded-full bg-blue-50 text-blue-900 text-sm font-bold border border-blue-100">
                    قيمنا
                </span>
                <h2 data-aos="fade-up" class="text-4xl md:text-6xl font-black mb-6 text-gray-900">لماذا تختار الحمد؟</h2>
                <p data-aos="fade-up" data-aos-delay="100" class="text-gray-500 max-w-2xl mx-auto text-xl">نلتزم بأعلى معايير الجودة والمهنية في كل ما نقدمه</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
                <?php $__currentLoopData = $values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div data-aos="fade-up" data-aos-delay="<?php echo e($index * 150); ?>" class="bg-gray-50 p-10 rounded-[2rem] border border-transparent hover:border-blue-100 hover:bg-white text-center hover:shadow-2xl transition-all duration-300 group">
                        <div class="w-20 h-20 bg-white rounded-2xl shadow-lg flex items-center justify-center mx-auto mb-8 group-hover:scale-110 transition-transform duration-300 group-hover:bg-blue-600 group-hover:text-white text-blue-900">
                             <svg class="w-10 h-10" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/></svg>
                        </div>
                        <h3 class="text-2xl font-bold mb-4 text-gray-900"><?php echo e($value->title); ?></h3>
                        <p class="text-gray-600 leading-relaxed text-lg"><?php echo e($value->description); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Timeline Section -->
    <?php if(count($timeline) > 0): ?>
    <section class="py-32 bg-gray-900 overflow-hidden relative">
        <div class="max-w-7xl mx-auto px-4 relative z-10">
             <div class="text-center mb-24">
                <h2 data-aos="fade-up" class="text-4xl md:text-6xl font-black text-white mb-6">مسيرة النجاح</h2>
                <p data-aos="fade-up" class="text-gray-400 text-xl">تاريخ حافل بالإنجازات والتطور المستمر</p>
            </div>

            <div class="relative">
                <!-- Center Line -->
                <div class="absolute left-1/2 transform -translate-x-1/2 h-full w-1 bg-gradient-to-b from-transparent via-red-600 to-transparent hidden md:block opacity-50"></div>

                <div class="space-y-24">
                    <?php $__currentLoopData = $timeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="relative flex flex-col md:flex-row items-center <?php echo e($index % 2 == 0 ? 'md:flex-row-reverse' : ''); ?> gap-8 md:gap-0">
                            <!-- Content -->
                            <div class="w-full md:w-1/2 <?php echo e($index % 2 == 0 ? 'md:pr-24 text-right' : 'md:pl-24 text-left'); ?>">
                                <div data-aos="<?php echo e($index % 2 == 0 ? 'fade-right' : 'fade-left'); ?>" class="bg-[#0A1A3F] p-8 rounded-3xl shadow-xl border border-white/5 relative overflow-hidden group hover:bg-[#0f2456] transition-colors">
                                    <span class="block text-7xl font-black text-white/5 absolute top-0 right-0 z-0 select-none -translate-y-4 translate-x-4">
                                        <?php echo e($event->year); ?>

                                    </span>
                                    <div class="relative z-10">
                                        <span class="inline-block px-4 py-1 bg-red-600 text-white text-sm font-bold rounded-lg mb-4 shadow-lg"><?php echo e($event->year); ?></span>
                                        <h3 class="text-2xl font-bold text-white mb-3"><?php echo e($event->title); ?></h3>
                                        <p class="text-gray-300 text-lg leading-relaxed"><?php echo e($event->description); ?></p>
                                    </div>
                                </div>
                            </div>

                            <!-- Dot -->
                            <div class="absolute left-1/2 transform -translate-x-1/2 hidden md:flex items-center justify-center z-20">
                                <div class="w-6 h-6 bg-red-600 rounded-full shadow-[0_0_0_6px_rgba(255,255,255,0.1),0_0_20px_rgba(220,38,38,0.5)]"></div>
                            </div>
                            
                            <!-- Empty Space -->
                            <div class="w-full md:w-1/2 hidden md:block"></div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Contact & Map Section -->
    <section class="py-24 bg-gray-50" id="contact-map">
        <div class="max-w-7xl mx-auto px-4 h-[600px] flex flex-col md:flex-row gap-8">
            <!-- Info Cards (Overlaid on desktop) -->
            <div data-aos="fade-right" class="w-full md:w-1/3 space-y-6 z-10 md:-mr-16 md:mt-16 order-2 md:order-1 pointer-events-none">
                 <div class="bg-white p-8 rounded-2xl shadow-2xl border border-gray-100 pointer-events-auto transform transition hover:-translate-y-1">
                    <div class="flex items-start gap-5">
                        <div class="bg-blue-50 p-4 rounded-xl text-blue-600">
                            <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/></svg>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-900 mb-2 text-lg">اتصل بنا</h4>
                            <p class="text-gray-600 font-medium" dir="ltr"><?php echo e($siteSettings->contact_phone); ?></p>
                        </div>
                    </div>
                 </div>

                 <div class="bg-white p-8 rounded-2xl shadow-2xl border border-gray-100 pointer-events-auto transform transition hover:-translate-y-1">
                    <div class="flex items-start gap-5">
                        <div class="bg-red-50 p-4 rounded-xl text-red-600">
                           <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 10c0 6-8 12-8 12s-8-6-8-12a8 8 0 0 1 16 0Z"/><circle cx="12" cy="10" r="3"/></svg>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-900 mb-2 text-lg">زيارتنا</h4>
                            <p class="text-gray-600 font-medium"><?php echo e($siteSettings->contact_address); ?></p>
                        </div>
                    </div>
                 </div>

                 <div class="bg-white p-8 rounded-2xl shadow-2xl border border-gray-100 pointer-events-auto transform transition hover:-translate-y-1">
                    <div class="flex items-start gap-5">
                        <div class="bg-green-50 p-4 rounded-xl text-green-600">
                            <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect width="18" height="18" x="3" y="4" rx="2" ry="2"/><line x1="16" x2="16" y1="2" y2="6"/><line x1="8" x2="8" y1="2" y2="6"/><line x1="3" x2="21" y1="10" y2="10"/></svg>
                        </div>
                        <div>
                            <h4 class="font-bold text-gray-900 mb-2 text-lg">ساعات العمل</h4>
                            <p class="text-gray-600 font-medium">يومياً من 9 صباحاً - 10 مساءً</p>
                        </div>
                    </div>
                 </div>
            </div>

            <!-- Map Container -->
            <div data-aos="fade-in" class="flex-1 h-full rounded-[2.5rem] overflow-hidden shadow-inner border border-gray-200 order-1 md:order-2 z-0 relative" id="leaflet-map-container">
            </div>
        </div>
    </section>

    <!-- Swiper & Map Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Swiper
            const swiper = new Swiper('.main-slider', {
                loop: true,
                effect: 'fade',
                autoplay: {
                    delay: 6000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            });

            // Leaflet Map
            if (document.getElementById('leaflet-map-container')) {
                const map = L.map('leaflet-map-container', {
                   scrollWheelZoom: false
                }).setView([31.2330, 32.2882], 14);
                
                L.tileLayer('https://{s}.basemaps.cartocdn.com/rastertiles/voyager/{z}/{x}/{y}{r}.png', {
                    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors &copy; <a href="https://carto.com/attributions">CARTO</a>',
                    subdomains: 'abcd',
                    maxZoom: 20
                }).addTo(map);

                const icon = L.icon({
                    iconUrl: 'https://unpkg.com/leaflet@1.9.4/dist/images/marker-icon.png',
                    shadowUrl: 'https://unpkg.com/leaflet@1.9.4/dist/images/marker-shadow.png',
                    iconSize: [25, 41],
                    iconAnchor: [12, 41],
                });

                L.marker([31.2330, 32.2882], {icon: icon})
                 .addTo(map)
                 .bindPopup("<b><?php echo e($siteSettings->site_title); ?></b><br><?php echo e($siteSettings->contact_address); ?>")
                 .openPopup();
            }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06)): ?>
<?php $attributes = $__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06; ?>
<?php unset($__attributesOriginal42b37f006f8ebbe12b66cfa27a5def06); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42b37f006f8ebbe12b66cfa27a5def06)): ?>
<?php $component = $__componentOriginal42b37f006f8ebbe12b66cfa27a5def06; ?>
<?php unset($__componentOriginal42b37f006f8ebbe12b66cfa27a5def06); ?>
<?php endif; ?>
<?php /**PATH C:\Users\shoko\OneDrive\Desktop\Elhamd-main\Elhamd-Laravel\resources\views/public/home.blade.php ENDPATH**/ ?>