<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\UploadedFile;
use Tests\TestCase;

class AdminMediaUploadSecurityTest extends TestCase
{
    use RefreshDatabase;

    public function test_svg_upload_is_rejected(): void
    {
        $admin = User::factory()->create([
            'role' => 'SUPER_ADMIN',
            'email_verified_at' => now(),
        ]);

        $file = UploadedFile::fake()->create('payload.svg', 10, 'image/svg+xml');

        $this->actingAs($admin)
            ->from(route('admin.media'))
            ->post(route('admin.media.store'), ['file' => $file])
            ->assertSessionHasErrors('file');

        $this->assertDatabaseCount('media', 0);
    }
}
