<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ApiAuthTest extends TestCase
{
    use RefreshDatabase;

    public function test_api_user_endpoint_requires_token(): void
    {
        $this->getJson('/api/user')->assertUnauthorized();
    }

    public function test_api_user_endpoint_accepts_valid_token(): void
    {
        $user = User::factory()->create([
            'api_token' => 'test-api-token',
        ]);

        $this->withHeaders([
            'Authorization' => 'Bearer test-api-token',
        ])->getJson('/api/user')
            ->assertOk()
            ->assertJsonPath('id', $user->id);
    }
}
