<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class EmployeePortalTest extends TestCase
{
    use RefreshDatabase;

    public function test_employee_can_access_dashboard()
    {
        $user = User::factory()->create(['role' => 'EMPLOYEE']);

        $response = $this->actingAs($user)->get(route('employee.dashboard'));

        $response->assertStatus(200);
        $response->assertViewIs('employee.dashboard');
    }

    public function test_employee_can_submit_leave_request()
    {
        $user = User::factory()->create(['role' => 'EMPLOYEE']);

        $response = $this->actingAs($user)->post(route('employee.leaves.store'), [
            'leave_type' => 'ANNUAL',
            'start_date' => now()->addDays(1)->format('Y-m-d'),
            'end_date' => now()->addDays(2)->format('Y-m-d'),
            'reason' => 'Vacation',
        ]);

        $response->assertRedirect(route('employee.leaves.index'));
        $this->assertDatabaseHas('leave_requests', [
            'user_id' => $user->id,
            'leave_type' => 'ANNUAL',
            'status' => 'PENDING',
        ]);
    }

    public function test_employee_can_view_payroll()
    {
        $user = User::factory()->create(['role' => 'EMPLOYEE']);

        $response = $this->actingAs($user)->get(route('employee.payroll.index'));

        $response->assertStatus(200);
        $response->assertViewIs('employee.payroll.index');
    }
}
