<?php

namespace Tests\Feature;

use App\Models\ServiceType;
use App\Models\User;
use App\Models\Vehicle;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class PublicPagesTest extends TestCase
{
    use RefreshDatabase;

    public function test_home_page_can_be_rendered()
    {
        $response = $this->get('/');
        $response->assertStatus(200);
    }

    public function test_vehicles_index_page_can_be_rendered()
    {
        $response = $this->get('/vehicles');
        $response->assertStatus(200);
    }

    public function test_vehicle_detail_page_can_be_rendered()
    {
        $vehicle = Vehicle::factory()->create(['status' => 'AVAILABLE']);
        $response = $this->get('/vehicles/'.$vehicle->id);
        $response->assertStatus(200);
        $response->assertSee($vehicle->make);
    }

    public function test_service_booking_page_can_be_rendered()
    {
        // Ensure data exists
        ServiceType::factory()->create(['is_active' => true]);
        Vehicle::factory()->create(['status' => 'AVAILABLE']);

        $response = $this->get('/service-booking');
        $response->assertStatus(200);
    }

    public function test_test_drive_page_can_be_rendered()
    {
        Vehicle::factory()->create(['status' => 'AVAILABLE']);
        $response = $this->get('/test-drive');
        $response->assertStatus(200);
    }

    public function test_static_pages_can_be_rendered()
    {
        $pages = ['about', 'contact', 'terms', 'privacy', 'tata-motors'];

        foreach ($pages as $page) {
            $response = $this->get('/'.$page);
            $response->assertStatus(200);
        }
    }

    public function test_customer_dashboard_access()
    {
        $user = User::factory()->create();
        $response = $this->actingAs($user)->get('/customer/dashboard');
        $response->assertStatus(200);
    }

    public function test_guest_cannot_access_customer_dashboard()
    {
        $response = $this->get('/customer/dashboard');
        $response->assertRedirect('/login');
    }
}
