<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class SitemapTest extends TestCase
{
    use RefreshDatabase;

    public function test_sitemap_xml_is_generated()
    {
        $response = $this->get('/sitemap.xml');

        $response->assertStatus(200);
        $response->assertHeader('Content-Type', 'text/xml; charset=UTF-8');
        $response->assertSee('<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">', false);
        $response->assertSee(route('home'));
        $response->assertSee(route('about'));
    }

    public function test_arabic_terms_redirect()
    {
        $response = $this->get('/الشروط-والأحكام');
        $response->assertRedirect(route('terms'));
    }

    public function test_arabic_privacy_redirect()
    {
        $response = $this->get('/سياسة-الخصوصية');
        $response->assertRedirect(route('privacy'));
    }
}
