<?php

namespace Tests\Feature;

use App\Models\SiteSetting;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class StaticPagesTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // Create site settings to avoid null pointer exceptions in views if any
        SiteSetting::create([
            'site_name' => 'Elhamd Auto',
            'contact_email' => 'test@example.com',
            'contact_phone' => '123456789',
        ]);
    }

    public function test_parts_page_can_be_rendered()
    {
        $response = $this->get(route('parts'));
        $response->assertStatus(200);
        $response->assertSee('قطع الغيار الأصلية');
    }

    public function test_warranty_page_can_be_rendered()
    {
        $response = $this->get(route('warranty'));
        $response->assertStatus(200);
        $response->assertSee('الضمان الشامل');
    }

    public function test_faq_page_can_be_rendered()
    {
        $response = $this->get(route('faq'));
        $response->assertStatus(200);
        $response->assertSee('الأسئلة الشائعة');
    }

    public function test_support_page_can_be_rendered()
    {
        $response = $this->get(route('public.support'));
        $response->assertStatus(200);
        $response->assertSee('الدعم الفني');
    }
}
